/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.util.ui.notification;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import net.filebot.util.ui.notification.Direction;
import net.filebot.util.ui.notification.NotificationLayout;
import net.filebot.util.ui.notification.NotificationWindow;

public class SimpleNotificationLayout
implements NotificationLayout {
    private NotificationWindow current;
    private Direction alignment;

    public SimpleNotificationLayout() {
        this(Direction.NORTH);
    }

    public SimpleNotificationLayout(Direction alignment) {
        this.alignment = alignment;
    }

    private Point getBaseAnchor(Dimension screen, Insets insets) {
        Point p = new Point();
        screen.height -= insets.top + insets.bottom;
        screen.width -= insets.left + insets.right;
        p.x = (int)(this.alignment.ax * (double)screen.width);
        p.y = (int)(this.alignment.ay * (double)screen.height);
        p.x += insets.left;
        p.y += insets.top;
        return p;
    }

    private Point getLocation(Point anchor, Dimension size) {
        Point p = new Point();
        p.x = (int)((double)anchor.x - (double)size.width * this.alignment.ax);
        p.y = (int)((double)anchor.y - (double)size.height * this.alignment.ay);
        return p;
    }

    @Override
    public void add(NotificationWindow notification) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(notification.getGraphicsConfiguration());
        Dimension size = notification.getSize();
        Point anchor = this.getBaseAnchor(screen, insets);
        notification.setLocation(this.getLocation(anchor, size));
        if (this.current != null) {
            this.current.close();
        }
        this.current = notification;
    }

    @Override
    public void remove(NotificationWindow notification) {
        if (this.current != null && this.current == notification) {
            this.current.close();
        }
        this.current = null;
    }

    @Override
    public int size() {
        return this.current == null ? 0 : 1;
    }
}

