/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.vfs;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.logging.Level;
import net.filebot.Logging;
import net.filebot.vfs.MemoryFile;
import net.filebot.vfs.ZipArchive;

public enum ArchiveType {
    ZIP{

        @Override
        public Iterable<MemoryFile> fromData(ByteBuffer data) {
            return new ZipArchive(data);
        }
    }
    ,
    UNDEFINED{

        @Override
        public Iterable<MemoryFile> fromData(ByteBuffer data) {
            for (ArchiveType type : EnumSet.of(ZIP)) {
                try {
                    Iterable<MemoryFile> files = type.fromData(data);
                    if (!files.iterator().hasNext()) continue;
                    return files;
                }
                catch (Exception e) {
                    Logging.debug.log(Level.WARNING, e, e::toString);
                }
            }
            return Collections.emptySet();
        }
    }
    ,
    UNKOWN{

        @Override
        public Iterable<MemoryFile> fromData(ByteBuffer data) {
            return Collections.emptySet();
        }
    };


    public abstract Iterable<MemoryFile> fromData(ByteBuffer var1);

    public static ArchiveType forName(String name) {
        if (name == null) {
            return UNDEFINED;
        }
        if ("zip".equalsIgnoreCase(name)) {
            return ZIP;
        }
        return UNKOWN;
    }
}

