/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.vfs;

import java.io.File;
import java.util.Objects;
import net.filebot.util.FileUtilities;
import net.filebot.vfs.FileInfo;

public class SimpleFileInfo
implements FileInfo,
Comparable<FileInfo> {
    private String path;
    private long length;

    public SimpleFileInfo() {
    }

    public SimpleFileInfo(String path, long length) {
        this.path = path;
        this.length = length;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getName() {
        return FileUtilities.getNameWithoutExtension(new File(this.path).getName());
    }

    @Override
    public String getType() {
        return FileUtilities.getExtension(this.path);
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public int hashCode() {
        return Objects.hash(this.getPath(), this.getLength());
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileInfo) {
            FileInfo other = (FileInfo)obj;
            return other.getLength() == this.getLength() && other.getPath().equals(this.getPath());
        }
        return false;
    }

    @Override
    public int compareTo(FileInfo other) {
        return this.getPath().compareTo(other.getPath());
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public File toFile() {
        return new File(this.path);
    }
}

