/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeListProvider;
import net.filebot.web.SearchResult;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SortOrder;

public abstract class AbstractEpisodeListProvider
implements EpisodeListProvider {
    protected abstract List<SearchResult> fetchSearchResult(String var1, Locale var2) throws Exception;

    protected abstract SeriesData fetchSeriesData(SearchResult var1, SortOrder var2, Locale var3) throws Exception;

    @Override
    public List<SearchResult> search(String query, Locale language) throws Exception {
        return this.getSearchCache(language).computeIfAbsent(query, it -> this.fetchSearchResult(query, language));
    }

    protected SortOrder vetoRequestParameter(SortOrder order) {
        return order == null ? SortOrder.Airdate : order;
    }

    protected Locale vetoRequestParameter(Locale language) {
        return language == null || language.getLanguage().isEmpty() ? Locale.ENGLISH : language;
    }

    @Override
    public List<Episode> getEpisodeList(SearchResult searchResult, SortOrder sortOrder, Locale language) throws Exception {
        return this.getSeriesData(searchResult, sortOrder, language).getEpisodeList();
    }

    @Override
    public List<Episode> getEpisodeList(int id, SortOrder order, Locale language) throws Exception {
        return this.getEpisodeList(new SearchResult(id), order, language);
    }

    @Override
    public SeriesInfo getSeriesInfo(SearchResult searchResult, Locale language) throws Exception {
        return this.getSeriesData(searchResult, null, language).getSeriesInfo();
    }

    @Override
    public SeriesInfo getSeriesInfo(int id, Locale language) throws Exception {
        return this.getSeriesInfo(new SearchResult(id), language);
    }

    protected SeriesData getSeriesData(SearchResult searchResult, SortOrder order, Locale language) throws Exception {
        SortOrder requestOrder = this.vetoRequestParameter(order);
        Locale requestLanguage = this.vetoRequestParameter(language);
        return this.getDataCache(requestOrder, requestLanguage).computeIfAbsent(searchResult.getId(), it -> this.fetchSeriesData(searchResult, requestOrder, requestLanguage));
    }

    protected Cache getCache(String section) {
        return Cache.getCache(this.getName() + "_" + section, CacheType.Daily);
    }

    protected Cache.TypedCache<List<SearchResult>> getSearchCache(Locale language) {
        return this.getCache("search_" + language).castList(SearchResult.class);
    }

    protected Cache.TypedCache<SeriesData> getDataCache(SortOrder order, Locale language) {
        return this.getCache("data_" + order.ordinal() + "_" + language).cast(SeriesData.class);
    }

    protected static class SeriesData
    implements Serializable {
        public SeriesInfo seriesInfo;
        public Episode[] episodeList;

        public SeriesData() {
        }

        public SeriesData(SeriesInfo seriesInfo, List<Episode> episodeList) {
            this.seriesInfo = seriesInfo;
            this.episodeList = episodeList.toArray(new Episode[episodeList.size()]);
        }

        public SeriesInfo getSeriesInfo() {
            return this.seriesInfo.clone();
        }

        public List<Episode> getEpisodeList() {
            return Arrays.asList((Object[])this.episodeList.clone());
        }
    }
}

