/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.Icon;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.Logging;
import net.filebot.ResourceManager;
import net.filebot.util.JsonUtilities;
import net.filebot.util.RegularExpressions;
import net.filebot.web.AudioTrack;
import net.filebot.web.FloodLimit;
import net.filebot.web.MusicIdentificationService;
import net.filebot.web.SimpleDate;
import net.filebot.web.WebRequest;

public class AcoustIDClient
implements MusicIdentificationService {
    private static final FloodLimit REQUEST_LIMIT = new FloodLimit(3, 1L, TimeUnit.SECONDS);
    private String apikey;

    public AcoustIDClient(String apikey) {
        this.apikey = apikey;
    }

    @Override
    public String getIdentifier() {
        return "AcoustID";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.acoustid");
    }

    public Cache getCache() {
        return Cache.getCache(this.getName(), CacheType.Monthly);
    }

    @Override
    public Map<File, AudioTrack> lookup(Collection<File> files) throws Exception {
        LinkedHashMap<File, AudioTrack> results = new LinkedHashMap<File, AudioTrack>();
        for (File file : files) {
            String response;
            Map<ChromaprintField, String> fp = this.fpcalc(file);
            if (!fp.containsKey((Object)ChromaprintField.DURATION) || !fp.containsKey((Object)ChromaprintField.FINGERPRINT)) continue;
            int duration = Integer.parseInt(fp.get((Object)ChromaprintField.DURATION));
            String fingerprint = fp.get((Object)ChromaprintField.FINGERPRINT);
            if (duration < 10 || (response = this.lookup(duration, fingerprint)) == null || response.length() <= 0) continue;
            results.put(file, this.parseResult(this.lookup(duration, fingerprint), duration));
        }
        return results;
    }

    public String lookup(int duration, String fingerprint) throws Exception {
        LinkedHashMap<String, String> postParam = new LinkedHashMap<String, String>();
        postParam.put("duration", String.valueOf(duration));
        postParam.put("fingerprint", fingerprint);
        return (String)this.getCache().computeIfAbsent(((Object)postParam).toString(), it -> {
            REQUEST_LIMIT.acquirePermit();
            URL url = new URL("http://api.acoustid.org/v2/lookup?client=" + this.apikey + "&meta=recordings+releases+releasegroups+tracks+compress");
            HashMap<String, String> requestParam = new HashMap<String, String>();
            requestParam.put("Content-Encoding", "gzip");
            requestParam.put("Accept-Encoding", "gzip");
            return StandardCharsets.UTF_8.decode(WebRequest.post(url, postParam, requestParam)).toString();
        });
    }

    public AudioTrack parseResult(String json, int targetDuration) throws IOException {
        Object data = JsonUtilities.readJson(json);
        String status = JsonUtilities.getString(data, "status");
        if (!"ok".equals(status)) {
            throw new IOException(String.format("%s responded with error: %s", this.getName(), status));
        }
        int n = 0;
        Object[] objectArray = JsonUtilities.getArray(data, "results");
        int n2 = objectArray.length;
        if (n < n2) {
            Object result = objectArray[n];
            return JsonUtilities.streamJsonObjects(result, "recordings").sorted((r1, r2) -> {
                Integer i1 = JsonUtilities.getInteger(r1, "duration");
                Integer i2 = JsonUtilities.getInteger(r2, "duration");
                return Double.compare(i1 == null ? Double.NaN : (double)Math.abs(i1 - targetDuration), i2 == null ? Double.NaN : (double)Math.abs(i2 - targetDuration));
            }).map(recording -> {
                try {
                    Map<?, ?> releaseGroup = JsonUtilities.getFirstMap(recording, "releasegroups");
                    String artist = JsonUtilities.getString(JsonUtilities.getFirstMap(recording, "artists"), "name");
                    String title = JsonUtilities.getString(recording, "title");
                    if (artist == null || title == null || releaseGroup.isEmpty()) {
                        return null;
                    }
                    AudioTrack audioTrack = new AudioTrack(artist, title, null, this.getIdentifier());
                    audioTrack.mbid = JsonUtilities.getString(result, "id");
                    String type = JsonUtilities.getString(releaseGroup, "type");
                    Object[] secondaryTypes = JsonUtilities.getArray(releaseGroup, "secondarytypes");
                    Object[] releases = JsonUtilities.getArray(releaseGroup, "releases");
                    if (releases.length == 0 || secondaryTypes.length > 0 || !"Album".equals(type)) {
                        return audioTrack;
                    }
                    return JsonUtilities.streamJsonObjects(releases).map(release -> {
                        AudioTrack thisRelease = audioTrack.clone();
                        try {
                            Map<?, ?> date = JsonUtilities.getMap(release, "date");
                            thisRelease.albumReleaseDate = new SimpleDate(JsonUtilities.getInteger(date, "year"), JsonUtilities.getInteger(date, "month"), JsonUtilities.getInteger(date, "day"));
                        }
                        catch (Exception e) {
                            thisRelease.albumReleaseDate = null;
                        }
                        if (thisRelease.albumReleaseDate == null || thisRelease.albumReleaseDate.getTimeStamp() >= (audioTrack.albumReleaseDate == null ? Long.MAX_VALUE : audioTrack.albumReleaseDate.getTimeStamp())) {
                            return null;
                        }
                        Map<?, ?> medium = JsonUtilities.getFirstMap(release, "mediums");
                        thisRelease.mediumIndex = JsonUtilities.getInteger(medium, "position");
                        thisRelease.mediumCount = JsonUtilities.getInteger(release, "medium_count");
                        Map<?, ?> track = JsonUtilities.getFirstMap(medium, "tracks");
                        thisRelease.trackIndex = JsonUtilities.getInteger(track, "position");
                        thisRelease.trackCount = JsonUtilities.getInteger(medium, "track_count");
                        try {
                            thisRelease.album = JsonUtilities.getString(release, "title");
                        }
                        catch (Exception e) {
                            thisRelease.album = JsonUtilities.getString(releaseGroup, "title");
                        }
                        try {
                            thisRelease.albumArtist = JsonUtilities.getString(JsonUtilities.getFirstMap(releaseGroup, "artists"), "name");
                        }
                        catch (Exception e) {
                            thisRelease.albumArtist = null;
                        }
                        thisRelease.trackTitle = JsonUtilities.getString(track, "title");
                        if (!("Various Artists".equalsIgnoreCase(thisRelease.albumArtist) || thisRelease.album != null && thisRelease.album.contains("Greatest Hits"))) {
                            return thisRelease;
                        }
                        return null;
                    }).filter(Objects::nonNull).findFirst().orElse(audioTrack);
                }
                catch (Exception e) {
                    Logging.debug.log(Level.WARNING, e.getMessage(), e);
                    return null;
                }
            }).filter(Objects::nonNull).sorted(new MostFieldsNotNull()).findFirst().orElse(null);
        }
        return null;
    }

    public String getChromaprintCommand() {
        return System.getProperty("net.filebot.AcoustID.fpcalc", "fpcalc");
    }

    public Map<ChromaprintField, String> fpcalc(File file) throws IOException, InterruptedException {
        EnumMap<ChromaprintField, String> output;
        block16: {
            output = new EnumMap<ChromaprintField, String>(ChromaprintField.class);
            ProcessBuilder command = new ProcessBuilder(this.getChromaprintCommand(), file.getCanonicalPath());
            Process process = command.redirectError(ProcessBuilder.Redirect.INHERIT).start();
            Scanner scanner = new Scanner(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
            Throwable throwable = null;
            block11: while (true) {
                try {
                    while (scanner.hasNextLine()) {
                        String[] value = RegularExpressions.EQUALS.split(scanner.nextLine(), 2);
                        if (value.length != 2) continue;
                        try {
                            output.put(ChromaprintField.valueOf(value[0]), value[1]);
                            continue block11;
                        }
                        catch (Exception e) {
                            Logging.debug.warning(e::toString);
                        }
                    }
                    break block16;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (scanner != null) {
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
        return output;
    }

    private static class MostFieldsNotNull
    implements Comparator<Object> {
        private MostFieldsNotNull() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return Integer.compare(this.count(o2), this.count(o1));
        }

        public int count(Object o) {
            int n = 0;
            try {
                for (Field field : o.getClass().getDeclaredFields()) {
                    if (field.get(o) == null) continue;
                    ++n;
                }
            }
            catch (Exception e) {
                Logging.debug.log(Level.WARNING, e.getMessage(), e);
            }
            return n;
        }
    }

    public static enum ChromaprintField {
        FILE,
        FINGERPRINT,
        DURATION;

    }
}

