/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.Icon;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.CachedResource;
import net.filebot.Logging;
import net.filebot.Resource;
import net.filebot.ResourceManager;
import net.filebot.util.StringUtilities;
import net.filebot.util.XPathUtilities;
import net.filebot.web.AbstractEpisodeListProvider;
import net.filebot.web.Episode;
import net.filebot.web.EpisodeUtilities;
import net.filebot.web.FloodLimit;
import net.filebot.web.LocalSearch;
import net.filebot.web.SearchResult;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SimpleDate;
import net.filebot.web.SortOrder;
import org.jsoup.Jsoup;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AnidbClient
extends AbstractEpisodeListProvider {
    private static final FloodLimit REQUEST_LIMIT = new FloodLimit(2, 5L, TimeUnit.SECONDS);
    private final String client;
    private final int clientver;
    private final Resource<LocalSearch<SearchResult>> localIndex = Resource.lazy(() -> new LocalSearch<SearchResult>(this.getAnimeTitles(), SearchResult::getEffectiveNames));

    public AnidbClient(String client, int clientver) {
        this.client = client;
        this.clientver = clientver;
    }

    @Override
    public String getIdentifier() {
        return "AniDB";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.anidb");
    }

    @Override
    public boolean hasSeasonSupport() {
        return false;
    }

    @Override
    protected SortOrder vetoRequestParameter(SortOrder order) {
        return order == null ? SortOrder.Absolute : order;
    }

    @Override
    protected Cache getCache(String section) {
        return Cache.getCache(this.getName() + "_" + section, CacheType.Weekly);
    }

    @Override
    public List<SearchResult> search(String query, Locale locale) throws Exception {
        return this.fetchSearchResult(query, locale);
    }

    @Override
    public List<SearchResult> fetchSearchResult(String query, Locale locale) throws Exception {
        return this.localIndex.get().search(query);
    }

    @Override
    protected AbstractEpisodeListProvider.SeriesData fetchSeriesData(SearchResult anime, SortOrder sortOrder, Locale locale) throws Exception {
        Document dom = this.getXmlResource(anime.getId());
        String error = XPathUtilities.selectString("/error", dom);
        if (error != null && error.length() > 0) {
            throw new IllegalStateException(String.format("%s error: %s", this.getName(), error));
        }
        SeriesInfo seriesInfo = new SeriesInfo(this, sortOrder, locale, anime.getId());
        seriesInfo.setAliasNames(anime.getAliasNames());
        String animeType = XPathUtilities.selectString("//type", dom);
        if (animeType != null && animeType.matches("(?i:music.video|unkown)")) {
            return new AbstractEpisodeListProvider.SeriesData(seriesInfo, Collections.emptyList());
        }
        seriesInfo.setName(XPathUtilities.selectString("anime/titles/title[@type='main']", dom));
        seriesInfo.setRating(XPathUtilities.getDecimal(XPathUtilities.selectString("anime/ratings/permanent", dom)));
        seriesInfo.setRatingCount(StringUtilities.matchInteger(XPathUtilities.getTextContent("anime/ratings/permanent/@count", dom)));
        seriesInfo.setStartDate(SimpleDate.parse(XPathUtilities.selectString("anime/startdate", dom)));
        seriesInfo.setGenres(XPathUtilities.streamNodes("anime/categories/category", dom).map(categoryNode -> {
            String name = XPathUtilities.getTextContent("name", categoryNode);
            Integer weight = StringUtilities.matchInteger(XPathUtilities.getAttribute("weight", categoryNode));
            return new AbstractMap.SimpleImmutableEntry<String, Integer>(name, weight);
        }).filter(nw -> nw.getKey() != null && nw.getValue() != null && ((String)nw.getKey()).length() > 0 && (Integer)nw.getValue() >= 400).sorted((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue())).map(it -> (String)it.getKey()).limit(5L).collect(Collectors.toList()));
        String animeTitle = XPathUtilities.selectString("anime/titles/title[@type='official' and @lang='" + this.getLanguageCode(locale) + "']", dom);
        if (animeTitle == null || animeTitle.length() == 0) {
            animeTitle = seriesInfo.getName();
        }
        ArrayList<Episode> episodes = new ArrayList<Episode>(25);
        for (Node node : XPathUtilities.selectNodes("anime/episodes/episode", dom)) {
            Node epno = XPathUtilities.getChild("epno", node);
            int number = Integer.parseInt(XPathUtilities.getTextContent(epno).replaceAll("\\D", ""));
            int type = Integer.parseInt(XPathUtilities.getAttribute("type", epno));
            if (type != 1 && type != 2) continue;
            Integer id = Integer.parseInt(XPathUtilities.getAttribute("id", node));
            SimpleDate airdate = SimpleDate.parse(XPathUtilities.getTextContent("airdate", node));
            String title = XPathUtilities.selectString(".//title[@lang='" + this.getLanguageCode(locale) + "']", node);
            if (title.isEmpty()) {
                title = XPathUtilities.selectString(".//title[@lang='en']", node);
            }
            if (type == 1) {
                if (sortOrder == SortOrder.AbsoluteAirdate && airdate != null) {
                    number = airdate.getYear() * 10000 + airdate.getMonth() * 100 + airdate.getDay();
                }
                episodes.add(new Episode(animeTitle, null, number, title, number, null, airdate, id, new SeriesInfo(seriesInfo)));
                continue;
            }
            episodes.add(new Episode(animeTitle, null, null, title, null, number, airdate, id, new SeriesInfo(seriesInfo)));
        }
        episodes.sort(EpisodeUtilities.episodeComparator());
        if (episodes.isEmpty()) {
            Logging.debug.fine(Logging.format("No episode data: %s (%d) => %s", anime, anime.getId(), this.getResource(anime.getId())));
        }
        return new AbstractEpisodeListProvider.SeriesData(seriesInfo, episodes);
    }

    private Document getXmlResource(int aid) throws Exception {
        Cache cache = Cache.getCache(this.getName(), CacheType.Monthly);
        return cache.xml(aid, this::getResource).fetch(CachedResource.withPermit(CachedResource.fetchIfModified(), r -> REQUEST_LIMIT.acquirePermit())).expire(Cache.ONE_WEEK).get();
    }

    private URL getResource(int aid) throws Exception {
        return new URL("http://api.anidb.net:9001/httpapi?request=anime&client=" + this.client + "&clientver=" + this.clientver + "&protover=1&aid=" + aid);
    }

    @Override
    public URI getEpisodeListLink(SearchResult searchResult) {
        return URI.create("http://anidb.net/a" + searchResult.getId());
    }

    public String getLanguageCode(Locale locale) {
        String code;
        switch (code = locale.getLanguage()) {
            case "iw": {
                return "he";
            }
            case "in": {
                return "id";
            }
        }
        return code;
    }

    public SearchResult[] getAnimeTitles() throws Exception {
        byte[] bytes = this.getCache("root").bytes("anime-titles.dat.gz", n -> new URL("http://anidb.net/api/" + n)).get();
        Pattern pattern = Pattern.compile("^(?!#)(\\d+)[|](\\d)[|]([\\w-]+)[|](.+)$");
        ArrayList<String> languageOrder = new ArrayList<String>();
        languageOrder.add("x-jat");
        languageOrder.add("en");
        languageOrder.add("ja");
        ArrayList<String> typeOrder = new ArrayList<String>();
        typeOrder.add("1");
        typeOrder.add("4");
        typeOrder.add("2");
        typeOrder.add("3");
        HashMap entriesByAnime = new HashMap(65536);
        try (BufferedReader text = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), StandardCharsets.UTF_8));){
            text.lines().forEach(line -> {
                Matcher matcher = pattern.matcher((CharSequence)line);
                if (matcher.matches()) {
                    int aid = Integer.parseInt(matcher.group(1));
                    String type = matcher.group(2);
                    String language = matcher.group(3);
                    String title = matcher.group(4);
                    if (aid > 0 && title.length() > 0 && typeOrder.contains(type) && languageOrder.contains(language)) {
                        title = Jsoup.parse(title).text();
                        if (type.equals("3") && (title.length() < 5 || !Character.isUpperCase(title.charAt(0)) || Character.isUpperCase(title.charAt(title.length() - 1)))) {
                            return;
                        }
                        entriesByAnime.computeIfAbsent(aid, k -> new ArrayList()).add(new Object[]{typeOrder.indexOf(type), languageOrder.indexOf(language), title});
                    }
                }
            });
        }
        return (SearchResult[])entriesByAnime.entrySet().stream().map(it -> {
            List names = ((List)it.getValue()).stream().sorted((a, b) -> {
                for (int i = 0; i < ((Object[])a).length; ++i) {
                    if (a[i].equals(b[i])) continue;
                    return ((Comparable)a[i]).compareTo(b[i]);
                }
                return 0;
            }).map(n -> n[2].toString()).collect(Collectors.toList());
            String primaryTitle = (String)names.get(0);
            List<String> aliasNames = names.subList(1, names.size());
            return new SearchResult((int)((Integer)it.getKey()), primaryTitle, aliasNames);
        }).toArray(SearchResult[]::new);
    }
}

