/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Artwork
implements Serializable {
    protected String[] tags;
    protected URL url;
    protected String language;
    protected Double rating;
    public static final Comparator<Artwork> RATING_ORDER = Comparator.comparing(Artwork::getRating, Collections.reverseOrder());

    public Artwork() {
    }

    public Artwork(Stream<?> tags, URL url, Locale language, Double rating) {
        this.tags = (String[])tags.filter(Objects::nonNull).map(Object::toString).toArray(String[]::new);
        this.url = url;
        this.language = language == null || language.getLanguage().isEmpty() ? null : language.getLanguage();
        this.rating = rating;
    }

    public List<String> getTags() {
        return Collections.unmodifiableList(Arrays.asList(this.tags));
    }

    public URL getUrl() {
        return this.url;
    }

    public Locale getLanguage() {
        return this.language == null ? null : new Locale(this.language);
    }

    public double getRating() {
        return this.rating == null ? 0.0 : this.rating;
    }

    public boolean matches(Object ... tags) {
        if (tags == null || tags.length == 0) {
            return true;
        }
        return Arrays.stream(tags).filter(Objects::nonNull).map(Object::toString).allMatch(tag -> Arrays.stream(this.tags).anyMatch(tag::equalsIgnoreCase) || tag.equalsIgnoreCase(this.language));
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Artwork) {
            Artwork artwork = (Artwork)other;
            return this.url.sameFile(artwork.url);
        }
        return false;
    }

    public String toString() {
        return Stream.of(String.join((CharSequence)"/", this.tags), this.language, this.rating, this.url).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }
}

