/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.filebot.web.EpisodeFormat;
import net.filebot.web.SeriesInfo;
import net.filebot.web.SimpleDate;

public class Episode
implements Serializable {
    protected String seriesName;
    protected Integer season;
    protected Integer episode;
    protected String title;
    protected Integer absolute;
    protected Integer special;
    protected SimpleDate airdate;
    protected Integer id;
    protected SeriesInfo seriesInfo;

    public Episode() {
    }

    public Episode(Episode obj) {
        this(obj.seriesName, obj.season, obj.episode, obj.title, obj.absolute, obj.special, obj.airdate, obj.id, obj.seriesInfo);
    }

    public Episode(String seriesName, Integer season, Integer episode, String title) {
        this(seriesName, season, episode, title, null, null, null, null, null);
    }

    public Episode(String seriesName, Integer season, Integer episode, String title, Integer absolute, Integer special, SimpleDate airdate, Integer id, SeriesInfo seriesInfo) {
        this.seriesName = seriesName;
        this.season = season;
        this.episode = episode;
        this.title = title;
        this.absolute = absolute;
        this.special = special;
        this.airdate = airdate == null ? null : airdate.clone();
        this.id = id;
        this.seriesInfo = seriesInfo == null ? null : seriesInfo.clone();
    }

    public String getSeriesName() {
        return this.seriesName;
    }

    public Integer getEpisode() {
        return this.episode;
    }

    public Integer getSeason() {
        return this.season;
    }

    public String getTitle() {
        return this.title;
    }

    public Integer getAbsolute() {
        return this.absolute;
    }

    public Integer getSpecial() {
        return this.special;
    }

    public SimpleDate getAirdate() {
        return this.airdate;
    }

    public Integer getId() {
        return this.id;
    }

    public SeriesInfo getSeriesInfo() {
        return this.seriesInfo;
    }

    public List<Integer> getNumbers() {
        return Arrays.asList(this.season, this.episode, this.special, this.absolute);
    }

    public List<String> getSeriesNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (this.seriesName != null) {
            names.add(this.seriesName);
        }
        if (this.seriesInfo != null) {
            if (this.seriesInfo.name != null) {
                names.add(this.seriesInfo.name);
            }
            if (this.seriesInfo.aliasNames != null) {
                for (String it : this.seriesInfo.aliasNames) {
                    names.add(it);
                }
            }
        }
        return new ArrayList<String>(names);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Episode) {
            Episode other = (Episode)obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id) && Objects.equals(this.seriesInfo, other.seriesInfo);
            }
            return Objects.equals(this.season, other.season) && Objects.equals(this.episode, other.episode) && Objects.equals(this.absolute, other.absolute) && Objects.equals(this.special, other.special) && Objects.equals(this.seriesName, other.seriesName) && Objects.equals(this.title, other.title);
        }
        return false;
    }

    public int hashCode() {
        return this.id != null ? this.id : Objects.hash(this.season, this.episode, this.absolute, this.special, this.seriesName, this.title);
    }

    public Episode clone() {
        return new Episode(this);
    }

    public String toString() {
        return EpisodeFormat.SeasonEpisode.format(this);
    }
}

