/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.File;
import java.io.FileFilter;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import net.filebot.Logging;
import net.filebot.MediaTypes;
import net.filebot.ResourceManager;
import net.filebot.mediainfo.MediaInfo;
import net.filebot.util.FileUtilities;
import net.filebot.util.StringUtilities;
import net.filebot.web.AudioTrack;
import net.filebot.web.Episode;
import net.filebot.web.MusicIdentificationService;
import net.filebot.web.SimpleDate;

public class ID3Lookup
implements MusicIdentificationService {
    @Override
    public String getIdentifier() {
        return "ID3";
    }

    @Override
    public String getName() {
        return "ID3 Tags";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.mediainfo");
    }

    @Override
    public Map<File, AudioTrack> lookup(Collection<File> files) {
        return this.read(files, this::getAudioTrack, MediaTypes.AUDIO_FILES, MediaTypes.VIDEO_FILES);
    }

    private <T> Map<File, T> read(Collection<File> files, Function<MediaInfo, T> parse, FileFilter ... filters) {
        LinkedHashMap<File, T> info = new LinkedHashMap<File, T>(files.size());
        try (MediaInfo m = new MediaInfo();){
            for (File f : FileUtilities.filter(files, filters)) {
                try {
                    m.open(f);
                    T object = parse.apply(m);
                    if (object == null) continue;
                    info.put(f, object);
                }
                catch (Throwable e) {
                    Logging.debug.warning(e::getMessage);
                }
            }
        }
        return info;
    }

    public AudioTrack getAudioTrack(File file) {
        return this.read(file, this::getAudioTrack);
    }

    public Episode Episode(File file) {
        return this.read(file, this::getEpisode);
    }

    private <T> T read(File file, Function<MediaInfo, T> parse) {
        Throwable throwable = null;
        try (MediaInfo m = new MediaInfo();){
            T t = parse.apply(m.open(file));
            return t;
        }
        catch (Throwable e) {
            Logging.debug.warning(e::getMessage);
        }
        return null;
    }

    public AudioTrack getAudioTrack(MediaInfo m) {
        Integer year;
        String artist = this.getString(m, "Performer", "Composer");
        String title = this.getString(m, "Title", "Track");
        if (artist == null || title == null) {
            return null;
        }
        String album = this.getString(m, "Album");
        String albumArtist = this.getString(m, "Album/Performer");
        String trackTitle = this.getString(m, "Track");
        Integer mediumIndex = null;
        Integer mediumCount = null;
        Integer trackIndex = this.getInteger(m, "Track/Position");
        Integer trackCount = this.getInteger(m, "Track/Position_Total");
        String mbid = this.getString(m, "Acoustid Id");
        String dateString = this.getString(m, "Recorded_Date");
        SimpleDate albumReleaseDate = SimpleDate.parse(dateString);
        if (albumReleaseDate == null && (year = StringUtilities.matchInteger(dateString)) != null) {
            albumReleaseDate = new SimpleDate(year, 1, 1);
        }
        return new AudioTrack(artist, title, album, albumArtist, trackTitle, albumReleaseDate, mediumIndex, mediumCount, trackIndex, trackCount, mbid, this.getIdentifier());
    }

    public Episode getEpisode(MediaInfo m) {
        String series = this.getString(m, "Album");
        Integer season = this.getInteger(m, "Season");
        Integer episode = this.getInteger(m, "Part", "Track/Position");
        String title = this.getString(m, "Title", "Track");
        if (series == null || episode == null) {
            return null;
        }
        return new Episode(series, season, episode, title);
    }

    private String getString(MediaInfo mediaInfo, String ... keys) {
        for (String key : keys) {
            String value = mediaInfo.get(MediaInfo.StreamKind.General, 0, key);
            if (value.length() <= 0) continue;
            return value;
        }
        return null;
    }

    private Integer getInteger(MediaInfo mediaInfo, String ... keys) {
        return StringUtilities.matchInteger(this.getString(mediaInfo, keys));
    }
}

