/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.filebot.web.SearchResult;

public class Movie
extends SearchResult {
    protected int year;
    protected int imdbId;
    protected int tmdbId;
    protected String language;

    public Movie() {
    }

    public Movie(int imdbId) {
        this(null, null, 0, imdbId, 0, null);
    }

    public Movie(String name, int year) {
        this(name, null, year, 0, 0, null);
    }

    public Movie(String name, int year, int imdbId) {
        this(name, null, year, imdbId, 0, null);
    }

    public Movie(String name, String[] aliasNames, int year, int imdbId, int tmdbId, Locale locale) {
        super(tmdbId > 0 ? tmdbId : (imdbId > 0 ? imdbId : 0), name, aliasNames);
        this.year = year;
        this.imdbId = imdbId;
        this.tmdbId = tmdbId;
        this.language = locale == null ? null : locale.getLanguage();
    }

    public int getYear() {
        return this.year;
    }

    public int getImdbId() {
        return this.imdbId;
    }

    public int getTmdbId() {
        return this.tmdbId;
    }

    public Locale getLanguage() {
        return this.language == null ? null : new Locale(this.language);
    }

    public String getNameWithYear() {
        return Movie.toString(this.name, this.year);
    }

    @Override
    public List<String> getEffectiveNames() {
        if (this.aliasNames == null || this.aliasNames.length == 0) {
            return Collections.singletonList(Movie.toString(this.name, this.year));
        }
        ArrayList<String> names = new ArrayList<String>(1 + this.aliasNames.length);
        names.add(Movie.toString(this.name, this.year));
        for (String alias : this.aliasNames) {
            names.add(Movie.toString(alias, this.year));
        }
        return names;
    }

    public List<String> getEffectiveNamesWithoutYear() {
        return super.getEffectiveNames();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Movie) {
            Movie other = (Movie)object;
            if (this.tmdbId > 0 && other.tmdbId > 0) {
                return this.tmdbId == other.tmdbId;
            }
            if (this.imdbId > 0 && other.imdbId > 0) {
                return this.imdbId == other.imdbId;
            }
            return this.year == other.year && this.name.equals(other.name);
        }
        return false;
    }

    @Override
    public Movie clone() {
        return new Movie(this.name, this.aliasNames, this.year, this.imdbId, this.tmdbId, this.getLanguage());
    }

    @Override
    public String toString() {
        return Movie.toString(this.name, this.year);
    }

    private static String toString(String name, int year) {
        return String.format("%s (%04d)", name, year < 0 ? 0 : year);
    }
}

