/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import net.filebot.Logging;
import net.filebot.util.ByteBufferOutputStream;
import net.filebot.util.FileUtilities;
import net.filebot.web.SubtitleDescriptor;

public class OpenSubtitlesSubtitleDescriptor
implements SubtitleDescriptor,
Serializable {
    private final Map<Property, String> properties;
    private static int DOWNLOAD_QUOTA = 1000;

    public OpenSubtitlesSubtitleDescriptor(Map<Property, String> properties) {
        this.properties = properties;
    }

    public Map<Property, String> getProperties() {
        return this.properties;
    }

    public String getProperty(Property key) {
        return this.properties.get((Object)key);
    }

    @Override
    public String getPath() {
        return this.getProperty(Property.SubFileName);
    }

    @Override
    public String getName() {
        return FileUtilities.getNameWithoutExtension(this.getProperty(Property.SubFileName));
    }

    @Override
    public String getLanguageName() {
        return this.getProperty(Property.LanguageName);
    }

    @Override
    public String getType() {
        return this.getProperty(Property.SubFormat);
    }

    @Override
    public long getLength() {
        return Long.parseLong(this.getProperty(Property.SubSize));
    }

    public String getMovieHash() {
        return this.getProperty(Property.MovieHash);
    }

    public long getMovieByteSize() {
        return Long.parseLong(this.getProperty(Property.MovieByteSize));
    }

    public String getMovieReleaseName() {
        return this.getProperty(Property.MovieReleaseName);
    }

    public int getQueryNumber() {
        return Integer.parseInt(this.getProperty(Property.QueryNumber));
    }

    public float getMovieFPS() {
        return Float.parseFloat(this.getProperty(Property.MovieFPS));
    }

    public long getMovieTimeMS() {
        return Long.parseLong(this.getProperty(Property.MovieTimeMS));
    }

    public int getSubActualCD() {
        return Integer.parseInt(this.getProperty(Property.SubActualCD));
    }

    public int getSubSumCD() {
        return Integer.parseInt(this.getProperty(Property.SubSumCD));
    }

    public static synchronized void checkDownloadQuota() throws IllegalStateException {
        if (DOWNLOAD_QUOTA <= 0) {
            throw new IllegalStateException("Download-Quota has been exceeded");
        }
    }

    private static synchronized void setAndCheckDownloadQuota(int quota) throws IllegalStateException {
        DOWNLOAD_QUOTA = quota;
        OpenSubtitlesSubtitleDescriptor.checkDownloadQuota();
    }

    @Override
    public ByteBuffer fetch() throws Exception {
        OpenSubtitlesSubtitleDescriptor.checkDownloadQuota();
        URLConnection c = new URL(this.getProperty(Property.SubDownloadLink)).openConnection();
        try (InputStream in = c.getInputStream();){
            String quota = c.getHeaderField("Download-Quota");
            if (quota != null) {
                Logging.debug.finest("Download-Quota: " + quota);
                OpenSubtitlesSubtitleDescriptor.setAndCheckDownloadQuota(Integer.parseInt(quota));
            }
            ByteBufferOutputStream buffer = new ByteBufferOutputStream(this.getLength());
            buffer.transferFully(new GZIPInputStream(in));
            ByteBuffer byteBuffer = buffer.getByteBuffer();
            return byteBuffer;
        }
    }

    public int hashCode() {
        return this.getProperty(Property.IDSubtitle).hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof OpenSubtitlesSubtitleDescriptor) {
            OpenSubtitlesSubtitleDescriptor other = (OpenSubtitlesSubtitleDescriptor)object;
            return this.getProperty(Property.IDSubtitle).equals(other.getProperty(Property.IDSubtitle));
        }
        return false;
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public File toFile() {
        return new File(this.getPath());
    }

    public static enum Property {
        IDSubtitle,
        IDSubtitleFile,
        IDSubMovieFile,
        IDMovie,
        IDMovieImdb,
        SubFileName,
        SubLastTS,
        SubFormat,
        SubEncoding,
        SubHash,
        SubSize,
        MovieHash,
        MovieByteSize,
        MovieName,
        MovieNameEng,
        MovieYear,
        MovieReleaseName,
        MovieTimeMS,
        MovieFPS,
        MovieImdbRating,
        MovieKind,
        SeriesSeason,
        SeriesEpisode,
        SeriesIMDBParent,
        SubLanguageID,
        ISO639,
        LanguageName,
        UserID,
        UserRank,
        UserNickName,
        SubAddDate,
        SubAuthorComment,
        SubFeatured,
        SubComments,
        SubDownloadsCnt,
        SubHearingImpaired,
        SubRating,
        SubHD,
        SubBad,
        SubActualCD,
        SubSumCD,
        MatchedBy,
        QueryNumber,
        SubtitlesLink,
        SubDownloadLink,
        ZipDownloadLink;


        public static <V> EnumMap<Property, V> asEnumMap(Map<String, V> stringMap) {
            EnumMap<Property, V> enumMap = new EnumMap<Property, V>(Property.class);
            for (Map.Entry<String, V> entry : stringMap.entrySet()) {
                try {
                    enumMap.put(Property.valueOf(entry.getKey()), entry.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return enumMap;
        }
    }
}

