/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import net.filebot.Cache;
import net.filebot.CacheType;
import net.filebot.ResourceManager;
import net.filebot.util.FileUtilities;
import net.filebot.util.JsonUtilities;
import net.filebot.web.SubtitleDescriptor;
import net.filebot.web.VideoHashSubtitleService;
import net.filebot.web.WebRequest;

public class ShooterSubtitles
implements VideoHashSubtitleService {
    @Override
    public String getIdentifier() {
        return "Shooter";
    }

    @Override
    public String getName() {
        return "\u5c04\u624b\u7f51";
    }

    @Override
    public Icon getIcon() {
        return ResourceManager.getIcon("search.shooter");
    }

    @Override
    public URI getLink() {
        return URI.create("http://shooter.cn");
    }

    public Cache getCache() {
        return Cache.getCache(this.getName(), CacheType.Daily);
    }

    @Override
    public Map<File, List<SubtitleDescriptor>> getSubtitleList(File[] videoFiles, Locale locale) throws Exception {
        HashMap<File, List<SubtitleDescriptor>> result = new HashMap<File, List<SubtitleDescriptor>>();
        for (File it : videoFiles) {
            result.put(it, this.getSubtitleList(it, locale));
        }
        return result;
    }

    protected URL getSubApiUrl() {
        try {
            return new URL(System.getProperty("net.filebot.web.ShooterSubtitles.url", "https://www.shooter.cn/api/subapi.php"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized List<SubtitleDescriptor> getSubtitleList(File file, Locale locale) throws Exception {
        if (Stream.of(Locale.CHINESE, Locale.ENGLISH).noneMatch(l -> l.getLanguage().equals(locale.getLanguage()))) {
            throw new IllegalArgumentException("Language not supported: " + locale);
        }
        if (file.length() < 8192L) {
            return Collections.emptyList();
        }
        URL endpoint = this.getSubApiUrl();
        LinkedHashMap<String, String> param = new LinkedHashMap<String, String>();
        param.put("filehash", ShooterSubtitles.computeFileHash(file));
        param.put("pathinfo", file.getPath());
        param.put("format", "json");
        param.put("lang", Locale.CHINESE.getLanguage().equals(locale.getLanguage()) ? "Chn" : "Eng");
        return this.getCache().castList(SubtitleDescriptor.class).computeIfAbsent(((Object)param).toString(), it -> {
            ByteBuffer bb = WebRequest.post(endpoint, param, null);
            if (bb.remaining() == 1 && bb.get(0) == -1) {
                return Collections.emptyList();
            }
            String name = FileUtilities.getNameWithoutExtension(file.getName());
            Object response = JsonUtilities.readJson(StandardCharsets.UTF_8.decode(bb));
            return JsonUtilities.streamJsonObjects(response).flatMap(n -> JsonUtilities.streamJsonObjects(n, "Files")).map(f -> {
                String type = JsonUtilities.getString(f, "Ext");
                String link = JsonUtilities.getString(f, "Link");
                return new ShooterSubtitleDescriptor(name, type, link, locale.getDisplayLanguage(Locale.ENGLISH));
            }).limit(1L).collect(Collectors.toList());
        });
    }

    @Override
    public VideoHashSubtitleService.CheckResult checkSubtitle(File videoFile, File subtitleFile) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void uploadSubtitle(Object identity, Locale locale, File[] videoFile, File[] subtitleFile) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected static String computeFileHash(File file) throws IOException {
        ArrayList<String> hashes = new ArrayList<String>();
        long fileSize = file.length();
        if (fileSize < 8192L) {
            return "";
        }
        long[] offset = new long[4];
        offset[3] = fileSize - 8192L;
        offset[2] = fileSize / 3L;
        offset[1] = fileSize / 3L * 2L;
        offset[0] = 4096L;
        try (RandomAccessFile f = new RandomAccessFile(file, "r");){
            byte[] buffer = new byte[4096];
            for (int i = 0; i < 4; ++i) {
                f.seek(offset[i]);
                int read = f.read(buffer, 0, buffer.length);
                hashes.add(ShooterSubtitles.md5(buffer, 0, read));
            }
        }
        return String.join((CharSequence)";", hashes);
    }

    protected static String md5(byte[] input, int offset, int len) {
        try {
            MessageDigest hash = MessageDigest.getInstance("MD5");
            hash.update(input, offset, len);
            return String.format("%032x", new BigInteger(1, hash.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ShooterSubtitleDescriptor
    implements SubtitleDescriptor,
    Serializable {
        private String name;
        private String type;
        private String link;
        private String language;

        public ShooterSubtitleDescriptor(String name, String type, String link, String language) {
            this.name = name;
            this.type = type;
            this.link = link;
            this.language = language;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getLanguageName() {
            return this.language;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public ByteBuffer fetch() throws Exception {
            return WebRequest.fetch(new URL(this.link));
        }

        @Override
        public String getPath() {
            return this.getName() + "." + this.getType();
        }

        @Override
        public long getLength() {
            return -1L;
        }

        @Override
        public File toFile() {
            return new File(this.getPath());
        }

        public String toString() {
            return String.format("%s [%s]", this.getName(), this.getLanguageName());
        }
    }
}

