/*
 * Decompiled with CFR 0.152.
 */
package net.filebot.web;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum SortOrder {
    Airdate,
    DVD,
    Absolute,
    AbsoluteAirdate;


    public String toString() {
        switch (this) {
            case Airdate: {
                return "Airdate Order";
            }
            case DVD: {
                return "DVD Order";
            }
            case Absolute: {
                return "Absolute Order";
            }
        }
        return "Absolute Airdate Order";
    }

    public static List<String> names() {
        return Arrays.stream(SortOrder.values()).map(Enum::name).collect(Collectors.toList());
    }

    public static SortOrder forName(String name) {
        for (SortOrder order : SortOrder.values()) {
            if (!order.name().equalsIgnoreCase(name)) continue;
            return order;
        }
        throw new IllegalArgumentException(String.format("%s not in %s", name, SortOrder.names()));
    }
}

