
/*
 * https://github.com/WebKit/webkit/blob/master/Source/WebKit2/Shared/API/c/WKType.h
 * Copyright (C) 2010 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WKType_h
#define WKType_h

#include "WKBase.h"

#ifdef __cplusplus
extern "C" {
#endif

WK_EXPORT WKTypeID WKGetTypeID(WKTypeRef type);

WK_EXPORT WKTypeRef WKRetain(WKTypeRef type);
WK_EXPORT void WKRelease(WKTypeRef type);

/* https://lists.webkit.org/pipermail/webkit-help/2011-March/002000.html
 >>  All WK*Ref types are ref-counted. WKRetain and WKRelease work on any WK*Ref type. WebKit2's C API is modeled after CoreFoundation. You can find more information (including information about memory management) here:
 https://developer.apple.com/library/archive/documentation/CoreFoundation/Conceptual/CFDesignConcepts/CFDesignConcepts.html#//apple_ref/doc/uid/10000122
https://lists.webkit.org/pipermail/webkit-help/2010-April/000956.html
 Uses of CF/JS/WKRetain and Release should follow the "Create Rule" - if you used a Create() function, you are the owner (by default) and will need to release it later.
 https://developer.apple.com/library/archive/documentation/CoreFoundation/Conceptual/CFMemoryMgmt/Concepts/Ownership.html#//apple_ref/doc/uid/20001148-103029
*/

#ifdef __cplusplus
}
#endif

#endif /* WKType_h */
