import os
from substance_painter import logging
from . import version as gsg_version

# Logging class. On level
# <= 0 : none
# 1    : errors
# 2    : warnings
# 3    : info (default)
# >= 4 : debug
#
class Log:
    def __init__(self):
        self.level = int(os.environ.get('GREYSCALEGORILLA_SP_LOG_LEVEL') or 3)
        self.prefix = "Greyscalegorilla Connect " + gsg_version.version

    def debug(self, message):
        if self.level >= 4:
            logging.info(f'{self.prefix} - {message}')

    def info(self, message):
        if self.level >= 3:
            logging.info(f'{self.prefix} - {message}')

    def warning(self, message):
        if self.level >= 2:
            logging.warning(f'{self.prefix} - {message}')

    def error(self, message):
        if self.level >= 1:
            logging.error(f'{self.prefix} - {message}')
