import substance_painter.textureset as ts
from . import log as gsg_log

log = gsg_log.Log()

# coatopacity
# coatspecularlevel
# height
# indexofrefraction
# sheenopacity
# specularedgecolor
class ShaderParams:
    def __init__(self, in_meta, in_shader_name):
        self.shader_name = in_shader_name
        white = self.Color(1, 1, 1)
        zerov = self.Vector(0.0, 0.0, 0.0)
        self.params = {
            'base' :                {'value':0,     'channel':0},
            'base_color':           {'value':white, 'channel':ts.ChannelType.BaseColor},
            'coat':                 {'value':0,     'channel':0},
            'coat_color':           {'value':white, 'channel':ts.ChannelType.CoatColor},
            'coat_normal':          {'value':zerov, 'channel':ts.ChannelType.CoatNormal},
            'coat_roughness':       {'value':0.1,   'channel':ts.ChannelType.CoatRoughness},
            'diffuse_roughness':    {'value':0.0,   'channel':ts.ChannelType.Roughness},
            'metalness':            {'value':0.0,   'channel':ts.ChannelType.Metallic},
            'opacity':              {'value':white, 'channel':ts.ChannelType.Opacity},
            'sheen':                {'value':0.0,   'channel':0},
            'sheen_color':          {'value':white, 'channel':ts.ChannelType.SheenColor},
            'sheen_roughness':      {'value':0.3,   'channel':ts.ChannelType.SheenRoughness},
            'specular':             {'value':0.0,   'channel':ts.ChannelType.Specular},
            'specular_anisotropy':  {'value':0.0,   'channel':ts.ChannelType.Anisotropylevel},
            'specular_color':       {'value':white, 'channel':0},
            'specular_rotation':    {'value':0.0,   'channel':ts.ChannelType.Anisotropyangle},
            'transmission_scatter': {'value':0.0,   'channel':ts.ChannelType.Scattering}
        }

        self.in_gsgm = set()

        for arnold_name in self.params.keys():
            value = self.GetSimpleParamValue(in_meta, arnold_name)
            if value is not None:
                self.params[arnold_name]['value'] = value
                self.in_gsgm.add(arnold_name)

    def Color(self, r, g, b):
        return {'r': r, 'g': g, 'b': b}

    def Vector(self, x, y, z):
        return {'x': x, 'y': y, 'z': z}

    def Has(self, name):
        return name in self.params
    
    def GetSimpleParamValue(self, meta, param_name):
        if 'params' in meta and self.shader_name in meta['params'] and param_name in meta['params'][self.shader_name]:
            return meta['params'][self.shader_name][param_name]
        return None
    
    def Log(self):
        log.debug(f"in_gsgm: {self.in_gsgm}")
        for arnold_name in self.params.keys():
            log.debug(f"{arnold_name} = {self.params[arnold_name]['value']} {self.params[arnold_name]['channel']}")
