#include "FileTable.h"
#include <iostream>
#include <fstream>

FileTable::FileTable(const std::string& cvmPath)
{
	if(cvm_contents(cvmPath.c_str(), false, mContents))
	{
		std::cout << "Error reading BGM.CVM!\n";
		exit(1);
	}
}

void FileTable::write(const std::string& outPath)
{
	std::cout << "Writing BGM.CVM file table to " << outPath << "...";

	std::ofstream out(outPath, std::ios::out | std::ios::binary);

	//originally starts at 0x006418e0 in normal code
	unsigned int numEntries = mContents.getNumEntries();
	//yes, written twice
	out.write((char*)&numEntries, 4);
	out.write((char*)&numEntries, 4);

	unsigned int magicNumber = 0x14;
	out.write((char*)&magicNumber, 4);

	out.write("#DirLst#", 8);

	for(int j = 0; j < 4; j++)
		out.put('\0');

	//entries start (first is at 0x006418f8 in normal code)

	for(unsigned int i = 0; i < mContents.getNumEntries(); i++)
	{
		iso_entry e = mContents.entries.at(i);

		out.write((char*)&e.size, 4);
		out.write((char*)&e.extattrlen, 4);
		out.write((char*)&e.extent, 4);
		out.write((char*)&e.flags, 1);
		out.put('\0'); //mystery byte!


		char name[34];
		std::fill(name, name + 34, 0);

		if(i == 0)
		{
			name[0] = '.';
		}else if(i == 1)
		{
			name[0] = '.'; name[1] = '.';
		}else{
			for(int j = 0; j < e.nameLen; j++)
			{
				if(e.name[j] != ';')
				{
					name[j] = e.name[j];
				}else{
					break;
				}
			}
		}

		out.write(name, 34);
	}

	std::cout << "done.\n";

	out.close();
}
