#include "Patcher.h"
#include "PatchAction.h"

#include <boost/filesystem.hpp>

namespace fs = boost::filesystem;

Patcher::Patcher(const std::string& in, const std::string& out) : mInPath(in), mOutPath(out)
{

}

BlockData* Patcher::readBlockFromFile(const std::string& path, FileAddress* lenOut)
{
	if(!fs::exists(path))
	{
		std::cout << "Could not find file for read: \"" << path << "\"!\n";
		return NULL;
	}
	std::ifstream in(path, std::ios::in | std::ios::binary);
	
	if(in.bad())
	{
		std::cout << "Could not open file for read: \"" << path << "\"!\n";
		return NULL;
	}

	in.seekg(0, std::ios::end);
	*lenOut = (FileAddress)in.tellg();
	in.seekg(0, std::ios::beg);

	BlockData* data = new BlockData[*lenOut];
	in.read(data, *lenOut);
	in.close();

	return data;
}

void Patcher::queueWrite(FileAddress address, BlockData* data, unsigned int length)
{
	mQueue.push_back(new WriteAction(address, data, length));
}

void Patcher::queueWrite(FileAddress address, unsigned int data)
{
	BlockData* block = new BlockData[sizeof(data)];
	*((unsigned int*)block) = data;
	mQueue.push_back(new WriteAction(address, block, sizeof(data)));
}

void Patcher::queueIncUInt32(FileAddress addr, unsigned int amt)
{
	mQueue.push_back(new IncUInt32Action(addr, amt));
}

void Patcher::advanceTo(FileAddress addr, std::ifstream& in, std::ofstream& out)
{
	if(out.tellp() > addr)
	{
		//we already passed our target...
		std::cout << "WARNING - going backwards in patch!\n";
		out.seekp(addr);
		in.seekg(addr);
	}else if(out.tellp() < addr)
	{
		//there's stuff to copy in between here and there
		FileAddress amt = addr - (FileAddress)out.tellp();
		char* buff = new char[amt];
		in.read(buff, amt);
		out.write(buff, amt);
		delete[] buff;
	}
}

void Patcher::doWrite()
{
	std::ifstream in(mInPath, std::ios::in | std::ios::binary);
	std::ofstream out(mOutPath, std::ios::out | std::ios::binary);

	in.seekg(0, std::ios::end);
	FileAddress eofPos = (FileAddress)in.tellg();
	in.seekg(0, std::ios::beg);

	for(unsigned int i = 0; i < mQueue.size(); i++)
	{
		mQueue.at(i)->write(in, out);
	}

	//copy rest of file, if there is any...
	if(!in.eof())
		advanceTo(eofPos, in, out);

	in.close();
	out.close();
}
