#ifndef _PATCHER_H_
#define _PATCHER_H_

#include <vector>
#include <string>
#include <fstream>

typedef char BlockData;
typedef unsigned int FileAddress;

class PatchAction;

class Patcher
{
public:
	Patcher(const std::string& in, const std::string& out);

	//will free data on after patch is performed
	void queueWrite(FileAddress address, BlockData* data, unsigned int length);
	void queueWrite(FileAddress address, unsigned int data);
	void queueIncUInt32(FileAddress address, unsigned int inc);

	//actually perform the patch
	void doWrite();

	//helper methods
	static void advanceTo(FileAddress address, std::ifstream& in, std::ofstream& out);
	static BlockData* readBlockFromFile(const std::string& file, FileAddress* lenOut); //you are responsible for freeing the returned block of memory!

private:
	std::string mInPath;
	std::string mOutPath;

	std::vector<PatchAction*> mQueue;
};

#endif
