#include "PatchAction.h"
#include <iostream>

void WriteAction::write(std::ifstream& in, std::ofstream& out)
{
	if(mLength == 0)
	{
		std::cout << "WARNING - WRITING 0-LENGTH DATA\n";
	}

	Patcher::advanceTo(address, in, out);
	out.write(mData, mLength);
	in.ignore(mLength);
}

WriteAction::~WriteAction()
{
	delete[] mData;
}


void IncUInt32Action::write(std::ifstream& in, std::ofstream& out)
{
	Patcher::advanceTo(address, in, out);
	
	unsigned int curVal;
	in.read((char*)&curVal, sizeof(unsigned int));

	printf(" IncUInt32 %X -> ", curVal);
	curVal += mAmount;
	printf("%X\n", curVal);

	out.write((char*)&curVal, sizeof(unsigned int));
}
