#include "Patcher.h"

class PatchAction
{
public:
	PatchAction(FileAddress addr) : address(addr) {};
	
	const FileAddress address;

	virtual void write(std::ifstream& in, std::ofstream& out) = 0;
};

class WriteAction : public PatchAction
{
public:
	WriteAction(FileAddress addr, BlockData* data, unsigned int len) : PatchAction(addr), mData(data), mLength(len) {};
	~WriteAction();

	void write(std::ifstream& in, std::ofstream& out);

private:
	BlockData* mData;
	unsigned int mLength;
};

class IncUInt32Action : public PatchAction
{
public:
	IncUInt32Action(FileAddress addr, unsigned int val) : PatchAction(addr), mAmount(val) {};
	
	void write(std::ifstream& in, std::ofstream& out);

private:
	unsigned int mAmount;
};
