#pragma once

#include <stdio.h>
#include <vector>

struct iso_entry
{
	unsigned int size;
	int extattrlen;
	char flags;
	unsigned int extent; //offset
	
	int nameLen;
	char name[38];
};

struct iso_contents
{
public:
	std::vector<iso_entry> entries;
	unsigned int getNumEntries() { return entries.size(); };

};


class Iso9660Parser
{
  FILE *f;
  unsigned char *key;
  int keyLen;
  int sectorSize;
  int isoZoneSector;
  int isoStartSector;
  int end_dir_sect;

  int isoToLogical (int isosec) { return isosec + isoZoneSector - isoStartSector; };
  int isoToPhysical(int isosec) { return isosec + isoStartSector; };
  bool read_sectors_raw(void* buf, int isosec, int numsects, bool decrypt);

  bool parseDirForContents(iso_contents& contents, int extent, int size, bool verbose);

public:
  Iso9660Parser(FILE *_f, int _isoStartSector, int _isoZoneSector, unsigned char *_key, int _keyLen, int _sectorSize = 0x800):
   f(_f), isoStartSector(_isoStartSector), isoZoneSector(_isoZoneSector), key(_key), keyLen(_keyLen), sectorSize(_sectorSize),
   end_dir_sect(-1)
  {
  };
  
  bool getContents(iso_contents& contents, bool verbose = true);

  int get_end_dirs() { return end_dir_sect; };
  bool read_sector(void* buf, int isosec);
  void set_key(unsigned char *_key, int _keyLen) { key = _key; keyLen = _keyLen; };
};

int cvm_contents(const char *cvm_file, bool verbose, iso_contents& contents);
