<%@ WebHandler Language="C#" Class="uploadFile" %>

using System.IO;
using System.Web;
using System;
using System.Diagnostics;
using WebApiServiceMobile.Models.V2;
using WebApiServiceMobile.Handlers;

public class uploadFile : IHttpHandler
{
    public async void ProcessRequest(HttpContext _context)
    {
        LogHandler.WriteAlertLog("Acessado rota para subir os arquivos.", "uploadFiles");
        
        try
        {
            int unidade = _context.Request.Headers["Unidade"] != null ? Convert.ToInt32(_context.Request.Headers["Unidade"]) : 0;
            string planilha = _context.Request.Headers["Planilha"];
            string tipo = _context.Request.Headers["Tipo"];
            string uploadDir = Funcoes.RetornaPastaArquivos(unidade);

            if (_context.Request.Files.Count == 0)
            {
                _context.Response.Write("<result><status>Error</status><message>No files selected</message></result>");
                return;
            }

            foreach (string fileKey in _context.Request.Files)
            {
                var file = _context.Request.Files[fileKey];

                try
                {
                    var nomeArquivo = ArquivoMobile.FormataNomeArquivo(file.FileName, tipo, planilha);

                    var arquivoTemporario = string.Concat(AppDomain.CurrentDomain.BaseDirectory, "TempFiles\\", nomeArquivo);
                    file.SaveAs(arquivoTemporario);

                    var unidadeResult = Unidade.BuscarUnidade(unidade);
                    if (unidadeResult.S3Ativo)
                    {
                        var fileInfo = new FileInfo(arquivoTemporario);
                        await new ArquivoMobile().SalvarArquivoS3(unidade, planilha, tipo, fileInfo);
                        File.Delete(arquivoTemporario);
                    }
                    else
                    {
                        var fileDir = Path.Combine(uploadDir, nomeArquivo);
                        if (File.Exists(fileDir))
                        {
                            File.Delete(fileDir);
                        }

                        file.SaveAs(fileDir);
                    }
                }
                catch (IOException ex)
                {
                    Trace.WriteLine(DateTime.Now.ToString() + " - Erro ao criar o arquivo: " + ex.Message);
                }
            }

            _context.Response.Write("<result><status>Success</status><message>Upload completed</message></result>");
            LogHandler.WriteAlertLog("Sucesso ao subir os arquivos.", "uploadFiles");
        }
        catch (Exception e)
        {
            LogHandler.WriteErrorLog("uploadFile", "Erro ao processar requisição de upload.", "uploadFile");
            throw new Exception(e.Message);
        }
    }

    public bool IsReusable
    {
        get { return true; }
    }
}