/* eslint-disable no-nested-ternary */
import React from 'react'
import { Icon, Button } from 'semantic-ui-react'
import { t } from 'ttag'

function Bar (props) {
  const showClass = props.showHome ? 'display-none'
    : (props.showIngredients || props.showProfiles) ? 'display-none'
      : 'bar-profile display-block'
  const showButton = props.showHome ? 'display-none' : 'bar-profile display-block'
  const formattedOg = props.recipe.og ? (props.recipe.og).toFixed(3) : ''
  const formattedFg = props.recipe.fg ? (props.recipe.fg).toFixed(3) : ''
  return (
    <div className='bar'>
      <Button icon>
        <div className={showButton}><Icon name='left arrow' onClick={props.toggleHome} /></div>
      </Button>
      <div className={showClass}>
        <div>{props.recipe.ibu} IBU</div>
        <div>{props.recipe.ebc} EBC</div>
        <div>{ t`OG` } {formattedOg}</div>
        <div>{ t`FG` } {formattedFg}</div>
        <div>{ t`BU/GU ratio` } {props.recipe.bugu}</div>
        <div>Alc {props.recipe.alc} %</div>
      </div>
      <Button icon>
        <Icon name='settings' onClick={props.onShowPrefClick} />
      </Button>
    </div>
  )
}

export default Bar
