import React from 'react'
import { Icon } from 'semantic-ui-react'
import { Tabs, TabList, Tab, TabPanels, TabPanel } from '@reach/tabs'
import '@reach/tabs/styles.css'
import ClassicMode from './ClassicMode'
import BiabMode from './BiabMode'
import styled from 'styled-components/macro'

const StyledTabs = styled(Tabs)`
  [data-reach-tab-list] {
    background-color:white;
    font-weight:bold;
  }
  [data-reach-tab] {
    margin-top:10px;
    padding-bottom:10px;
  }
  [data-reach-tab][data-selected] {
   border-bottom: solid 2px #1070CA;
  }
  
`

function BrewdayCard (props) {
  return (
    <div className='brewday'>
      <div className='brewday-title'><Icon circular inverted size='small' name='tasks' /> Brewday Mode</div>
      <StyledTabs>
        <TabList>
          <Tab style={{ marginLeft: '32px', marginRight: '25px' }}>Classic Mode</Tab>
          <Tab>BIAB Mode</Tab>
        </TabList>

        <TabPanels>
          <TabPanel>
            <ClassicMode
              recipe={props.recipe}
              classic={props.classic}
              mash_profiles={props.mash_profiles}
              handleClassicTempChange={props.handleClassicTempChange}
              handleClassicBaseRatioChange={props.handleClassicBaseRatioChange}
              onMashDetailsClick={props.onMashDetailsClick}
            />
          </TabPanel>
          <TabPanel>
            <BiabMode
              recipe={props.recipe}
              biab={props.biab}
              handleBiabTargetChange={props.handleBiabTargetChange}
            />
          </TabPanel>

        </TabPanels>
      </StyledTabs>
    </div>

  )
}

export default BrewdayCard
