import React from 'react'
import { Input, Dropdown, Button, Icon, Form } from 'semantic-ui-react'
import { t } from 'ttag'

function FermentablePanel (props) {
  const showClass = props.showFermentablePanel ? 'fermentable-panel' : 'display-none'
  const typeOptions = [
    {
      text: t`Grain`,
      value: 'Grain'
    },
    {
      text: t`Sugar`,
      value: 'Sugar'
    },
    {
      text: t`Extract`,
      value: 'Extract'
    },
    {
      text: t`Dry extract`,
      value: 'Dry extract'
    },
    {
      text: t`Adjunct`,
      value: 'Adjunct'
    }
  ]
  const useOptions = [
    {
      text: t`Add to mash`,
      value: 'add_to_mash'
    },
    {
      text: t`Add to boil`,
      value: 'add_to_boil'
    },
    {
      text: t`Add to flame out`,
      value: 'add_to_flameout'
    },
    {
      text: t`Add to fermentation`,
      value: 'add_to_fermentation'
    },
    {
      text: t`Add to package`,
      value: 'add_to_package'
    }
  ]

  return (
    <div className={showClass}>
      <Button icon>
        <Icon name='close' onClick={props.onFermentablePanelToggle} />
      </Button>
      <div>
        <Form>
          <Form.Field inline>
            <Input type='text' className='name-input' onChange={(e, data) => props.onFermentableChanged('Name updated', e, data)} value={props.ingredient.name} />
          </Form.Field>
        </Form>
        <Button className='open-picker' onClick={props.onPickFermentableClicked}>{ t`pick ingredient` }</Button>
        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Amount (g)` }</label>
            </div>
            <Input type='number' onChange={(e, data) => props.onFermentableChanged('Amount updated', e, data)} value={props.ingredient.amount} min='0' step='1' />
          </Form.Field>
          <Form.Field inline style={{ fontWeight: '700', color: '#14B5D0' }}>
            <div><label style={{ fontWeight: '700', color: '#14B5D0' }}>Ratio</label></div>
            {Math.round(props.ingredient.amountRatio * 1000) / 10} %
          </Form.Field>
        </Form>
        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Yield (%)` }</label>
            </div>
            <Input style={{ width: '60px' }} type='number' onChange={(e, data) => props.onFermentableChanged('Yield updated', e, data)} value={props.ingredient.yield} min='0' max='100' step='1' />
          </Form.Field>
        </Form>
        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Color (EBC)` }</label>
            </div>
            <Input style={{ width: '60px' }} type='number' onChange={(e, data) => props.onFermentableChanged('Color updated', e, data)} value={props.ingredient.color} min='0' step='1' />
          </Form.Field>
        </Form>
        <Dropdown selection options={typeOptions} onChange={(e, data) => props.onFermentableChanged('Type updated', e, data)} value={props.ingredient.type} />
        <Dropdown selection options={useOptions} onChange={(e, data) => props.onFermentableChanged('Use updated', e, data)} value={props.ingredient.use} />

      </div>
      <div className='delete-button delete-editor'>
        <Button onClick={e => props.deleteIngredient('fermentable', e)}>{ t`Delete` }</Button>
      </div>
    </div>
  )
}

export default FermentablePanel
