import React, { useState } from 'react'
import * as utils from './lib/utils'
import { Button, Icon } from 'semantic-ui-react'
import SearchInput, { createFilter } from 'react-search-input'
import { Box } from 'rebass'

function HopPicker (props) {
  const [searchTerm, setSearchTerm] = useState('')
  const KEYS_TO_FILTERS = ['name']
  const hops = utils.sortListByName(props.hops.filter(createFilter(searchTerm, KEYS_TO_FILTERS)))

  const showClass = props.showPanel ? 'hop-picker' : 'display-none'

  return (
    <div className={showClass}>
      <Button icon>
        <Icon name='close' onClick={() => { props.onClosePanel(); setSearchTerm('') }} />
      </Button>
      <Box ml={3} mt={5}>
        <SearchInput style={{ color: '#425A70', fontSize: '13px', border: 'solid 1px #E4E7EB', borderRadius: '3px', height: '24px' }} icon='search' placeholder='Search...' onChange={setSearchTerm} value={searchTerm} />
      </Box>
      <ul>
        {hops.map(item => (
          <li key={item.id} onClick={() => props.onHopSelected(item)} >{item.name}</li>
        ))}
      </ul>
    </div>
  )
}

export default HopPicker
