import React from 'react'
import { t } from 'ttag'
import { Icon } from 'semantic-ui-react'

function HopsCards (props) {
  const display = use =>
    use === 'Boil' ? t`Boil`
      : use === 'Dry Hop' ? t`Dry Hop`
        : use === 'First Wort' ? t`First Wort`
          : use === 'Flame Out' ? t`Flame Out`
            : t`Boil`

  return (
    <div className='hops-block'>
      {props.recipe.hops.map(hop => (
        <div className='ingredient-card hop-card' onClick={() => props.onHopClick(hop)}>
          <div className='title-card'><div>{hop.name}</div> <div className='amount'>{Math.round(hop.amount)} g</div></div>
          <div className='detail-card'>
            <div>{display(hop.use)}</div>
            {hop.use === 'Dry Hop' ? <div className='hop-time'>{t`Day`} {hop.slotA || 0}  <Icon name='arrow right' />{hop.slotB || 0} </div> : <div className='hop-time'>{Math.round(hop.time)} min</div>}
          </div>
        </div>
      ))}
    </div>
  )
}

export default HopsCards
