import React, { useState } from 'react'
import { Icon, Button, Form, Input, Dropdown } from 'semantic-ui-react'
import { t } from 'ttag'

function Ingredients (props) {
  const showClass = props.showIngredients ? 'ingredients-page display-block' : 'display-none'

  const [showForm, setShowForm] = useState(false)
  const formClass = showForm ? 'ingredients-editor-view' : 'display-none'

  const grainTypeOptions = [
    {
      text: t`Grain`,
      value: 'Grain'
    },
    {
      text: t`Sugar`,
      value: 'Sugar'
    },
    {
      text: t`Extract`,
      value: 'Extract'
    },
    {
      text: t`Dry extract`,
      value: 'Dry extract'
    },
    {
      text: t`Adjunct`,
      value: 'Adjunct'
    }
  ]
  const miscsTypeOptions = [
    {
      text: t`Spice`,
      value: 'Spice'
    },
    {
      text: t`Fining`,
      value: 'Fining'
    },
    {
      text: t`Water agent`,
      value: 'Water agent'
    },
    {
      text: t`Herb`,
      value: 'Herb'
    },
    {
      text: t`Flavor`,
      value: 'Flavor'
    },
    {
      text: t`Other`,
      value: 'Other'
    }
  ]
  const hopFormOptions = [
    {
      text: t`Leaf`,
      value: 'Leaf'
    },
    {
      text: t`Pellet`,
      value: 'Pellet'
    },
    {
      text: t`Plug`,
      value: 'Plug'
    }
  ]
  const yeastFormOptions = [
    {
      text: t`Liquid`,
      value: 'Liquid'
    },
    {
      text: t`Dry`,
      value: 'Dry'
    },
    {
      text: t`Slant`,
      value: 'Slant'
    },
    {
      text: t`Culture`,
      value: 'Culture'
    }
  ]
  const newFermentable = {
    name: 'new fermentable',
    color: 0,
    yield: 0,
    type: 'Grain'
  }

  const newHop = {
    name: 'new Hop',
    alpha: 0,
    form: 'Leaf'
  }

  const newMisc = {
    name: 'new Misc',
    type: 'Spice',
    laboratory: '',
    product_id: '',
    attenuation: 75
  }

  const newYeast = {
    name: 'new Yeast',
    form: 'Dry',
    attenuation: 75,
    laboratory: '',
    product_id: ''
  }

  return (
    <div className={showClass}>
      <div className='ingredients-editor-select column-wrapper space-between'>
        <div>
          <div
            role='button'
            tabIndex={0}
            className={(props.selectedIngredientType === 'fermentables')
              ? ' ingredient-editor-select-item ingredient-editor-highlighted'
              : 'ingredient-editor-select-item'}
            onClick={e => { props.onIngredientTypeChanged('fermentables', e); setShowForm(false) }}
            onKeyPress={e => props.onIngredientTypeChanged('fermentables', e)}
          >
            <Icon name='folder' /> {t`Fermentables`}
          </div>
          <div
            role='button'
            tabIndex={0}
            className={(props.selectedIngredientType === 'hops')
              ? ' ingredient-editor-select-item ingredient-editor-highlighted'
              : 'ingredient-editor-select-item'}
            onClick={e => { props.onIngredientTypeChanged('hops', e); setShowForm(false) }}
            onKeyPress={e => props.onIngredientTypeChanged('hops', e)}
          >
            <Icon name='folder' /> {t`Hops`}
          </div>
          <div
            role='button'
            tabIndex={0}
            className={(props.selectedIngredientType === 'miscs')
              ? ' ingredient-editor-select-item ingredient-editor-highlighted'
              : 'ingredient-editor-select-item'}
            onClick={e => { props.onIngredientTypeChanged('miscs', e); setShowForm(false) }}
            onKeyPress={e => props.onIngredientTypeChanged('miscs', e)}
          >
            <Icon name='folder' /> {t`Miscs`}
          </div>
          <div
            role='button'
            tabIndex={0}
            className={(props.selectedIngredientType === 'yeasts')
              ? ' ingredient-editor-select-item ingredient-editor-highlighted'
              : 'ingredient-editor-select-item'}
            onClick={e => { props.onIngredientTypeChanged('yeasts', e); setShowForm(false) }}
            onKeyPress={e => props.onIngredientTypeChanged('yeasts', e)}
          >
            <Icon name='folder' /> {t`Yeasts`}
          </div>
        </div>
        <div>
          {/*          <Button className='import-ingredients' icon onClick={props.onOpenIngredientsLegacy}>
            <Icon name='download' />
            <span>Import from joliebulle3</span>
          </Button> */}
          <Button className='import-ingredients' icon onClick={props.onRestoreIngredients}>
            <Icon name='sync' />
            <span>{t`Restore`}</span>
          </Button>
        </div>
        {/* <Button circular icon labelPosition="left" onClick={e => props.addIngredient(newFermentable, 'fermentable', e)}>
          <Icon name="plus" />
          Add fermentable
        </Button> */}
      </div>
      <div className='ingredients-editor-list'>
        {(props.selectedIngredientType === 'fermentables')
          ? <div>
            <div className='add-ingredient-editor' >
              <Button icon onClick={e => { props.addIngredient(newFermentable, 'fermentable', e); setShowForm(true) }}><Icon name='plus' /> {t`Add fermentable`}</Button>
            </div>
            <ul>
              {props.ingredients.fermentables.map(item =>
                (<li onClick={e => { props.onIngredientEditorSelected(item, e); setShowForm(true) }}>{item.name}</li>))}
            </ul>
          </div>
          : (props.selectedIngredientType === 'hops')
            ? <div>
              <div
                role='button'
                className='add-ingredient-editor'
              >
                <Button icon onClick={e => { props.addIngredient(newHop, 'hop', e); setShowForm(true) }}><Icon name='plus' /> {t`Add hop`}</Button>
              </div>
              <ul>
                {props.ingredients.hops.map(item =>
                  (<li onClick={e => { props.onIngredientEditorSelected(item, e); setShowForm(true) }}>{item.name}</li>))}
              </ul>
            </div>
            : (props.selectedIngredientType === 'miscs')
              ? <div>
                <div
                  role='button'
                  className='add-ingredient-editor'
                >
                  <Button icon onClick={e => { props.addIngredient(newMisc, 'misc', e); setShowForm(true) }}><Icon name='plus' /> {t`Add misc`}</Button>
                </div>
                <ul>
                  {props.ingredients.miscs.map(item =>
                    (<li onClick={e => { props.onIngredientEditorSelected(item, e); setShowForm(true) }}>{item.name}</li>))}
                </ul>
              </div>
              : (props.selectedIngredientType === 'yeasts')
                ? <div>
                  <div
                    role='button'
                    className='add-ingredient-editor'
                  >
                    <Button icon onClick={e => { props.addIngredient(newYeast, 'yeast', e); setShowForm(true) }}><Icon name='plus' /> {t`Add yeast`}</Button>

                  </div>
                  <ul>
                    {props.ingredients.yeasts.map(item =>
                      (<li onClick={e => { props.onIngredientEditorSelected(item, e); setShowForm(true) }}>{item.name}</li>))}
                  </ul>
                </div>
                : <ul />
        }
      </div>
      <div className={formClass}>
        {(props.selectedIngredientType === 'fermentables')
          ? <div className='ingredients-editor-view-card'>
            <Form>
              <Form.Field inline>
                <Input
                  type='text'
                  className='name-input'
                  value={props.selectedIngredientEditor.name}
                  onChange={(e, data) => props.onFermentableEditorChanged('Name updated', e, data)}
                />
              </Form.Field>
            </Form>
            <Dropdown
              selection
              options={grainTypeOptions}
              value={props.selectedIngredientEditor.type}
              onChange={(e, data) => props.onFermentableEditorChanged('Type updated', e, data)}
            />
            <Form>
              <Form.Field inline>
                <div>
                  <label>{t`Color (EBC)`} : </label>
                </div>
                <Input
                  type='number'
                  value={props.selectedIngredientEditor.color}
                  min='0' step='1'
                  onChange={(e, data) => props.onFermentableEditorChanged('Color updated', e, data)}
                />
              </Form.Field>
            </Form>
            <Form>
              <Form.Field inline>
                <div>
                  <label>{t`Yield (%)` } : </label>
                </div>
                <Input
                  type='number'
                  value={props.selectedIngredientEditor.yield}
                  min='0' max='100' step='1'
                  onChange={(e, data) => props.onFermentableEditorChanged('Yield updated', e, data)}
                />
              </Form.Field>
            </Form>
            <div className='delete-button delete-editor'>
              <Button onClick={e => { props.deleteIngredient('fermentables', e); setShowForm(false) }}>{t`Delete`}</Button>
            </div>

          </div>
          : (props.selectedIngredientType === 'hops')
            ? <div className='ingredients-editor-view-card'>
              <Form>
                <Form.Field inline>
                  <Input
                    type='text'
                    className='name-input'
                    value={props.selectedIngredientEditor.name}
                    onChange={(e, data) => props.onHopEditorChanged('Name updated', e, data)}
                  />
                </Form.Field>
              </Form>
              <Dropdown
                selection
                options={hopFormOptions}
                value={props.selectedIngredientEditor.form}
                onChange={(e, data) => props.onHopEditorChanged('Form updated', e, data)}
              />
              <Form>
                <Form.Field inline>
                  <div>
                    <label>{t`Alpha acid (%)` } : </label>
                  </div>
                  <Input
                    type='number'
                    value={props.selectedIngredientEditor.alpha}
                    min='0' max='100' step='1'
                    onChange={(e, data) => props.onHopEditorChanged('Alpha updated', e, data)}
                  />
                </Form.Field>
              </Form>
              <div className='delete-button delete-editor'>
                <Button onClick={e => { props.deleteIngredient('hops', e); setShowForm(false) }}>{t`Delete`}</Button>
              </div>
            </div>
            : (props.selectedIngredientType === 'miscs')
              ? <div className='ingredients-editor-view-card'>
                <Form>
                  <Form.Field inline>
                    <Input
                      type='text'
                      className='name-input'
                      value={props.selectedIngredientEditor.name}
                      onChange={(e, data) => props.onMiscEditorChanged('Name updated', e, data)}
                    />
                  </Form.Field>
                </Form>
                <Dropdown
                  selection
                  options={miscsTypeOptions}
                  value={props.selectedIngredientEditor.type}
                  onChange={(e, data) => props.onMiscEditorChanged('Type updated', e, data)}
                />
                <div className='delete-button delete-editor'>
                  <Button onClick={e => { props.deleteIngredient('miscs', e); setShowForm(false) }}>{t`Delete`}</Button>
                </div>
              </div>
              : (props.selectedIngredientType === 'yeasts')
                ? <div className='ingredients-editor-view-card'>
                  <Form>
                    <Form.Field inline>
                      <Input
                        type='text'
                        className='name-input'
                        value={props.selectedIngredientEditor.name}
                        onChange={(e, data) => props.onYeastEditorChanged('Name updated', e, data)}
                      />
                    </Form.Field>
                  </Form>
                  <Dropdown
                    selection
                    options={yeastFormOptions}
                    value={props.selectedIngredientEditor.form}
                    onChange={(e, data) => props.onYeastEditorChanged('Form updated', e, data)}
                  />
                  <Form>
                    <Form.Field inline>
                      <div>
                        <label>{t`Laboratory`} : </label>
                      </div>
                      <Input
                        type='text'
                        value={props.selectedIngredientEditor.laboratory}
                        onChange={(e, data) => props.onYeastEditorChanged('Laboratory updated', e, data)}
                      />
                    </Form.Field>
                  </Form>
                  <Form>
                    <Form.Field inline>
                      <div>
                        <label>ID : </label>
                      </div>
                      <Input
                        type='text'
                        value={props.selectedIngredientEditor.product_id}
                        onChange={(e, data) => props.onYeastEditorChanged('Product_id updated', e, data)}
                      />
                    </Form.Field>
                  </Form>
                  <Form>
                    <Form.Field inline>
                      <div>
                        <label>{t`Attenuation (%)`} : </label>
                      </div>
                      <Input
                        type='number'
                        value={props.selectedIngredientEditor.attenuation}
                        min='0' max='100' step='1'
                        onChange={(e, data) => props.onYeastEditorChanged('Attenuation updated', e, data)}
                      />
                    </Form.Field>
                  </Form>
                  <div className='delete-button delete-editor'>
                    <Button onClick={e => { props.deleteIngredient('yeasts', e); setShowForm(false) }}>{t`Delete`}</Button>
                  </div>
                </div>
                : <span />
        }
      </div>
    </div>
  )
}

export default Ingredients
