import React from 'react'
import { Dropdown, Button, Icon } from 'semantic-ui-react'
import { t } from 'ttag'

function MashPanel (props) {
  const showClass = props.showMashPanel ? 'mash-panel' : 'display-none'
  const mashOptions = props.mash_profiles.reduce((list, mash) => {
    const option = { text: mash.name, value: mash.id }
    return list.concat([option])
  }, [])

  return (
    <div className={showClass}>
      <Button icon>
        <Icon name='close' onClick={props.onMashPanelToggle} />
      </Button>
      <div className='mash-panel-details'>
        <div className='default-text medium-weight'>{props.recipe.mash.name}</div>
        <div className='default-text'> {t`pH`}: {props.recipe.mash.ph}</div>
        <div className='default-text'>{t`Sparge temp`}: {props.recipe.mash.sparge_temp}°C</div>
      </div>
      <div className='mash-panel-select'>
        <span className='default-text medium-weight'>{t`Change profile`}:</span>
        <Dropdown selection options={mashOptions} onChange={(e, data) => props.onProfileChanged('Profile updated', e, data)} />
      </div>
    </div>
  )
}

export default MashPanel
