import React from 'react'
import { t } from 'ttag'

function MiscsCards (props) {
  const display = use =>
    use === 'Boil' ? t`Boil`
      : use === 'Mash' ? t`Mash`
        : use === 'Primary' ? t`Primary`
          : use === 'Secondary' ? t`Secondary`
            : use === 'Bottling' ? t`Bottling`
              : t`Boil`

  return (
    <div className='miscs-block'>
      {props.recipe.miscs.map(misc => (
        <div className='ingredient-card misc-card' onClick={() => props.onMiscClick(misc)}>
          <div className='title-card'><div>{misc.name}</div> <div className='amount'>{Math.round(misc.amount)} g</div></div>
          <div className='detail-card'><div>{display(misc.use)}</div> <div>{Math.round(misc.time)} min</div></div>
        </div>
      ))}
    </div>
  )
}

export default MiscsCards
