import React from 'react'
import { Button, Tab, Form, Input } from 'semantic-ui-react'
import { t } from 'ttag'

function ModalPreferences (props) {
  const showHideClassName = props.show ? 'preferences-modal display-block' : 'preferences-modal display-none'
  const panes = [
    {
      menuItem: 'General',
      render: () => (
        <Tab.Pane attached={false}>
          <Form size='mini'>
            <Form.Field inline>
              <label >{ t`Boil Off Rate (%/h)` }</label>
              <Input placeholder='10% / h' type='number' value={props.config.General.BoilOffRate} onChange={e => props.handleConfigGeneralChange('BoilOffRate', e)} min='0' max='100' step='1' />
            </Form.Field>
            <Form.Field inline>
              <label>{t`Cooling Loss (%)`}</label>
              <Input placeholder='5' type='number' value={props.config.General.CoolingLoss} onChange={e => props.handleConfigGeneralChange('CoolingLoss', e)} min='0' max='100' step='1' />
            </Form.Field>
            <Form.Field inline>
              <label>{t`Grain Temperature (°C)`}</label>
              <Input placeholder='20' type='number' value={props.config.General.GrainTemp} onChange={e => props.handleConfigGeneralChange('GrainTemp', e)} min='0' max='100' step='1' />
            </Form.Field>
            <Form.Field inline>
              <label>{t`Fudge Factor (water temps)` }</label>
              <Input placeholder='1.7' type='number' value={props.config.General.FudgeFactor} onChange={e => props.handleConfigGeneralChange('FudgeFactor', e)} min='0' step='0.1' />
            </Form.Field>
            <Form.Field inline>
              <label>{t`Grain Retention (l/kg)` }</label>
              <Input placeholder='1' type='number' value={props.config.General.GrainRetention} onChange={e => props.handleConfigGeneralChange('GrainRetention', e)} min='0' step='0.1' />
            </Form.Field>
          </Form>
          <Button className='close-pref' primary size='mini' onClick={() => props.onClosePrefClick()}>{t`Close`}</Button>
        </Tab.Pane>)
    },
    {
      menuItem: t`About`,
      render: () => (
        <Tab.Pane attached={false}>
          <div className='about'>
            <p className='medium-weight'>Joliebulle 4.0.0</p>
            <div>License <br />

              Copyright (c) 2010-2019 Pierre Tavares <br />

              THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
              IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
              FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
              AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
              LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
              OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
              SOFTWARE.
            </div>
            <div>
              We use open-source software :
              <ul>
                <li>Electron, Copyright (c) 2013-2019 GitHub Inc., MIT License</li>
                <li>React, Copyright (c) 2013-present, Facebook, Inc., MIT License</li>
                <li>react-search-input, by enkidevs, MIT License</li>
                <li>ini, Copyright (c) Isaac Z. Schlueter and Contributors, ISC License</li>
                <li>nanoid, Copyright 2017 Andrey Sitnik andrey@sitnik.ru, MIT License</li>
                <li>pixl-xml, Copyright (c) 2004 - 2019 Joseph Huckaby, MIT License</li>
                <li>Semantic-UI-React, Copyright (c) 2019 TechnologyAdvice, MIT License</li>
                <li>Underscore, Copyright (c) 2009-2019 Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors, MIT License
                </li>
                <li>We use a color scheme heavily inspired by Evergreen, Copyright © 2017 Segment.io, Inc., MIT License </li>
                <li>Roboto Font, Font data copyright Google 2012 Apache License Version 2.0</li>
              </ul>
            </div>
          </div>
          <Button className='close-pref' primary size='mini' onClick={() => props.onClosePrefClick()}>{t`Close`}</Button>

        </Tab.Pane>)
    }
  ]

  return (
    <div className={showHideClassName}>
      <section className='preferences-content' >
        <Tab menu={{
          secondary: true, pointing: true, vertical: true, fluid: true
        }} panes={panes} />
      </section>
    </div>
  )
}

export default ModalPreferences
