import React, { useState } from 'react'
import { Icon, Form, Input, Dropdown, Button } from 'semantic-ui-react'
import { t } from 'ttag'

function Profiles (props) {
  const showClass = props.showProfiles ? 'display-block' : 'display-none'

  const [showSteps, setShowSteps] = useState(false)
  const stepsClass = showSteps ? 'mash-profile-editor-stepList' : 'display-none'

  const [showForm, setShowForm] = useState(false)
  const formClass = showForm ? 'mash-profile-editor-stepEditor' : 'display-none'

  const stepOptions = [
    {
      text: t`Infusion`,
      value: 'Infusion'
    },
    {
      text: t`Temperature`,
      value: 'Temperature'
    },
    {
      text: t`Decoction`,
      value: 'Decoction'
    }
  ]

  return (
    <div className={showClass}>
      <div className='mash-profile-editor-select'>
        <div className='add-profile-button'>
          <Button icon onClick={props.addProfile}>
            <Icon name='plus' />
            { t`New profile` }
          </Button>
        </div>
        <ul>
          {props.profiles.map(item =>
            (<li className={(props.selectedProfile.id === item.id) ? 'profile-base-selected' : ''} onClick={e => { props.onProfileClicked(item, e); setShowSteps(true); setShowForm(false) }} key={item.id}> <Icon name='cog' /> {item.name}</li>))}
        </ul>
      </div>
      <div className={stepsClass}>
        <div className='profile-base-editor'>
          <Form>
            <Form.Field inline>
              <Input
                type='text'
                className='name-input'
                value={props.selectedProfile.name}
                onChange={(e, data) => props.onProfileBaseChanged('Name updated', e, data)}
              />
            </Form.Field>
          </Form>
          <Form>
            <Form.Field inline>
              <div>
                <label>pH : </label>
              </div>
              <Input
                type='number'
                value={props.selectedProfile.ph}
                onChange={(e, data) => props.onProfileBaseChanged('Ph updated', e, data)}
              />
            </Form.Field>
          </Form>
          <Form>
            <Form.Field inline>
              <div>
                <label>{t`Sparge`} : </label>
              </div>
              <Input
                type='number'
                value={props.selectedProfile.sparge_temp}
                onChange={(e, data) => props.onProfileBaseChanged('Sparge updated', e, data)}
              />
            </Form.Field>
          </Form>
        </div>
        <div className='add-profile-button'>
          <Button icon onClick={props.addStep}>
            <Icon name='plus' />
            {t`Add Step`}
          </Button>
        </div>
        <ul>
          {props.selectedProfile.mash_steps.map(item =>
            (<li onClick={e => { props.onStepClicked(item, e); setShowForm(true) }}>{item.name}</li>))}
        </ul>
        <div className='delete-profile'>
          <Button icon onClick={() => { props.deleteProfile(); setShowSteps(false); setShowForm(false) }}> <Icon name='minus' /> {t`Delete profile`}</Button>
        </div>
      </div>
      <div className={formClass}>
        <Form>
          <Form.Field inline>
            <Input
              type='text'
              className='name-input'
              value={props.selectedStep.name}
              onChange={(e, data) => props.onStepChanged('Name updated', e, data)}
            />
          </Form.Field>
        </Form>
        <Dropdown
          selection
          options={stepOptions}
          value={props.selectedStep.type}
          onChange={(e, data) => props.onStepChanged('Type updated', e, data)}
        />
        <Form>
          <Form.Field inline>
            <div>
              <label>{t`Temperature (°C)`}: </label>
            </div>
            <Input
              type='number'
              className='name-input'
              value={props.selectedStep.step_temp}
              onChange={(e, data) => props.onStepChanged('Temp updated', e, data)}
            />
          </Form.Field>
        </Form>
        <Form>
          <Form.Field inline>
            <div>
              <label>{t`Time (min)`}: </label>
            </div>
            <Input
              type='number'
              className='name-input'
              value={props.selectedStep.step_time}
              onChange={(e, data) => props.onStepChanged('Time updated', e, data)}
            />
          </Form.Field>
        </Form>
        <div className='delete-button delete-editor'>
          <Button onClick={() => { props.deleteStep(); setShowForm(false) }}>{t`Delete`}</Button>
        </div>
      </div>
    </div>
  )
}

export default Profiles
