import React from 'react'
import { Checkbox, Form, Input, Dropdown } from 'semantic-ui-react'

import { t } from 'ttag'

const electron = window.require('electron')
const ipcRenderer = electron.ipcRenderer

function RecipeBox (props) {
  return (
    <div className='recipe-box'>
      <div>
        <div className='name-box'>
          <Form>
            <Form.Field inline>
              <Input type='text' className='name-input' onChange={e => props.onRecipeChanged('Name updated', e)} value={props.recipe.name} />
            </Form.Field>
          </Form>
        </div>
        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Brewer` }</label>
            </div>
            <Input type='text' onChange={e => props.onRecipeChanged('Brewer updated', e)} value={props.recipe.brewer} />
          </Form.Field>
        </Form>
        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Style` }</label>
            </div>
            <Input type='text' onChange={e => props.onRecipeChanged('Style updated', e)} value={props.recipe.style.name} />
          </Form.Field>
        </Form>
        <div className='recipe-box-divider' />
        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Efficiency (%)` }</label>
            </div>
            <Input style={{ width: '60px' }} className='percent' type='number' onChange={e => props.onRecipeChanged('Efficiency updated', e)} value={props.recipe.efficiency} min='1' max='100' step='1' />
          </Form.Field>
        </Form>
        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Size (L)` }</label>
            </div>
            <Input style={{ width: '60px' }} className='liters' type='number' onChange={e => props.onRecipeChanged('Batch size updated', e)} value={props.recipe.batch_size} min='1' step='1' />
          </Form.Field>
        </Form>
        <Checkbox label={t`Scale ingredients`} onChange={props.toggleScale} />
        <div className='recipe-box-boil'>
          <Form>
            <Form.Field inline>
              <div>
                <label>{ t`Boil (min)` }</label>
              </div>
              <Input className='minutes' type='number' onChange={e => props.onRecipeChanged('Boil time updated', e)} value={props.recipe.boil_time} min='0' step='1' />
            </Form.Field>
          </Form>
        </div>
      </div>
      <div>
        <div className='recipe-box-export'>
          <Dropdown text={t`Export`} fluid upward>
            <Dropdown.Menu>
              <Dropdown.Item text='Print' onClick={() => ipcRenderer.send('print')} />
              <Dropdown.Item text='Markdown' onClick={e => props.onExportClicked('md', e)} />
              <Dropdown.Item text='HTML' onClick={e => props.onExportClicked('html', e)} />
              <Dropdown.Item text='XML' onClick={e => props.onExportClicked('xml', e)} />
              <Dropdown.Item text='Jb4' onClick={e => props.onExportClicked('jb4', e)} />
            </Dropdown.Menu>
          </Dropdown>
        </div>
        <div className='recipe-box-history'>
          <Dropdown text={t`Edit History`} fluid upward>
            <Dropdown.Menu>
              {props.history.map(recipe => <Dropdown.Item text={recipe.historyMessage} onClick={e => props.onRestoreRecipeClicked(recipe, e)} />) }
            </Dropdown.Menu>
          </Dropdown>
        </div>
      </div>
    </div>
  )
}

export default RecipeBox
