import React from 'react'
import { Dropdown } from 'semantic-ui-react'
import RecipeBox from './RecipeBox'
import FermentablePanel from './FermentablePanel'
import HopPanel from './HopPanel'
import MiscPanel from './MiscPanel'
import YeastPanel from './YeastPanel'
import MashPanel from './MashPanel'
import FermentablesCards from './FermentablesCards'
import HopsCards from './HopsCards'
import MiscsCards from './MiscsCards'
import YeastsCards from './YeastsCards'
import NotesCard from './NotesCard'
import BrewdayCard from './BrewdayCard'

function RecipeMain (props) {
  return (
    <div className='mainView'>
      <RecipeBox
        recipe={props.recipe}
        history={props.history}
        onRecipeSizeChanged={props.onRecipeSizeChanged}
        onRecipeEfficiencyChanged={props.onRecipeEfficiencyChanged}
        onRecipeChanged={props.onRecipeChanged}
        onExportClicked={props.onExportClicked}
        onRestoreRecipeClicked={props.onRestoreRecipeClicked}
        toggleScale={props.toggleScale}
      />
      <FermentablePanel
        ingredient={props.selectedIngredient}
        showFermentablePanel={props.showFermentablePanel}
        onFermentableChanged={props.onFermentableChanged}
        onFermentablePanelToggle={props.onFermentablePanelToggle}
        deleteIngredient={props.deleteIngredient}
        onPickFermentableClicked={props.onPickFermentableClicked}
      />
      <HopPanel
        ingredient={props.selectedIngredient}
        showHopPanel={props.showHopPanel}
        onHopPanelToggle={props.onHopPanelToggle}
        onHopChanged={props.onHopChanged}
        deleteIngredient={props.deleteIngredient}
        onPickHopClicked={props.onPickHopClicked}
      />
      <MiscPanel
        ingredient={props.selectedIngredient}
        showMiscPanel={props.showMiscPanel}
        onMiscPanelToggle={props.onMiscPanelToggle}
        onMiscChanged={props.onMiscChanged}
        deleteIngredient={props.deleteIngredient}
        onPickMiscClicked={props.onPickMiscClicked}
      />
      <YeastPanel
        ingredient={props.selectedIngredient}
        showYeastPanel={props.showYeastPanel}
        onYeastPanelToggle={props.onYeastPanelToggle}
        onYeastChanged={props.onYeastChanged}
        deleteIngredient={props.deleteIngredient}
        onPickYeastClicked={props.onPickYeastClicked}
      />

      <MashPanel
        recipe={props.recipe}
        showMashPanel={props.showMashPanel}
        onMashPanelToggle={props.onMashPanelToggle}
        mash_profiles={props.mash_profiles}
        onProfileChanged={props.onProfileChanged}
      />
      <Dropdown fluid pointing='right' icon='plus' className='add-ingredient-to-recipe'>
        <Dropdown.Menu>
          <Dropdown.Item text='Add fermentable' onClick={props.onAddFermentableToRecipe} />
          <Dropdown.Item text='Add hop' onClick={props.onAddHopToRecipe} />
          <Dropdown.Item text='Add misc' onClick={props.onAddMiscToRecipe} />
          <Dropdown.Item text='Add yeast' onClick={props.onAddYeastToRecipe} />
        </Dropdown.Menu>
      </Dropdown>
      <FermentablesCards recipe={props.recipe} onFermentableClick={props.onFermentableClick} />
      <HopsCards recipe={props.recipe} onHopClick={props.onHopClick} />
      <MiscsCards recipe={props.recipe} onMiscClick={props.onMiscClick} />
      <YeastsCards recipe={props.recipe} onYeastClick={props.onYeastClick} />
      <NotesCard recipe={props.recipe} onNotesChanged={props.onNotesChanged} />

      <BrewdayCard
        showBIAB={props.showBIAB}
        toggleBrewday={props.toggleBrewday}
        recipe={props.recipe}
        biab={props.biab}
        handleBiabTargetChange={props.handleBiabTargetChange}
        classic={props.classic}
        mash_profiles={props.mash_profiles}
        handleClassicTempChange={props.handleClassicTempChange}
        handleClassicBaseRatioChange={props.handleClassicBaseRatioChange}
        onMashDetailsClick={props.onMashDetailsClick}
      />

    </div>
  )
}

export default RecipeMain
