import React, { useState } from 'react'
import { t } from 'ttag'
import { StyledModalHeader, StyledInput, CloseModalButton } from '../StyledComponents/Components'
import {
  DialogOverlay,
  DialogContent
} from '@reach/dialog'
import '@reach/dialog/styles.css'
import { Box, Text, Flex } from 'rebass'

function DilutionTool (props) {
  const calcFinalGravity = (dilution) => {
    if (dilution.finalVol === 0) { return 0 }
    return ((dilution.initialVol * dilution.initialGravity) + (dilution.addedVolume * dilution.addedGravity)) / dilution.finalVol
  }

  const [dilution, setDilution] = useState({ 'initialVol': 10, 'initialGravity': 1.050, addedVolume: 0, addedGravity: 1.000, finalVol: 10, finalGravity: 1.050 })

  return (
    <DialogOverlay
      style={{ background: 'hsla(0, 100%, 100%, 0.9)', zIndex: '1000' }}
      isOpen={props.dialogShowDilution}
    >
      <DialogContent style={{ boxShadow: '0px 10px 50px hsla(0, 0%, 0%, 0.33)' }}>
        <StyledModalHeader>{t`Dilution`}</StyledModalHeader>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Initial Volume (L)`}</label></Box>
          <Box><StyledInput type='number' step='1' min='0' value={dilution.initialVol} onChange={e => setDilution({ ...dilution, initialVol: parseFloat(e.target.value), finalGravity: calcFinalGravity(dilution) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Original Gravity`}</label></Box>
          <Box><StyledInput type='number' step='0.001' min='1' value={dilution.initialGravity} onChange={e => setDilution({ ...dilution, initialGravity: parseFloat(e.target.value), finalGravity: calcFinalGravity(dilution) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label style={{ paddingRight: '25px' }}>{t`Added Volume (L)`}</label></Box>
          <Box><StyledInput type='number' step='1' min='0' value={dilution.addedVolume} onChange={e => setDilution({ ...dilution, addedVolume: parseFloat(e.target.value), finalVol: dilution.initialVol + parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label style={{ paddingRight: '25px' }}>{t`Addition gravity`}</label></Box>
          <Box><StyledInput type='number' step='0.001' min='0' value={dilution.addedGravity} onChange={e => setDilution({ ...dilution, addedGravity: parseFloat(e.target.value), finalGravity: calcFinalGravity(dilution) })} /></Box>
        </Flex>

        <Flex mt={4}>
          <Text fontWeight='bold' width='175px'>{t`Final Volume`}</Text>
          <Text>{dilution.finalVol} L</Text>
        </Flex>
        <Flex>
          <Text fontWeight='bold' width='175px'>{t`Final Gravity`}</Text>
          <Text>{Math.round(calcFinalGravity(dilution) * 1000) / 1000 }</Text>
        </Flex>

        <div className='row-reverse-wrapper'>
          <CloseModalButton onClick={() => props.closeDialogDilution()}>{t`Close`}</CloseModalButton>
        </div>
      </DialogContent>
    </DialogOverlay>
  )
}

export default DilutionTool
