import React, { useState } from 'react'
import { t } from 'ttag'
import { StyledModalHeader, StyledInput, CloseModalButton } from '../StyledComponents/Components'
import {
  DialogOverlay,
  DialogContent
} from '@reach/dialog'
import '@reach/dialog/styles.css'
import { Box, Flex, Text } from 'rebass'

function PlatoAlcTool (props) {
  const fgCalc = (fgBrix) => {
    const fg = 1.0000 - 0.0044993 * fgBrix.ob / 1.04 + 0.011774 * fgBrix.fb / 1.04 + 0.00027581 * Math.pow(fgBrix.ob / 1.04, 2) - 0.0012717 * Math.pow(fgBrix.fb / 1.04, 2) - 0.0000072800 * Math.pow(fgBrix.ob / 1.04, 3) + 0.000063293 * Math.pow(fgBrix.fb / 1.04, 3)
    return fg
  }
  const [fgBrix, setFgBrix] = useState({ ob: 22, fb: 10 })
  return (
    <DialogOverlay
      style={{ background: 'hsla(0, 100%, 100%, 0.9)', zIndex: '1000' }}
      isOpen={props.dialogShowFgPlato}
    >
      <DialogContent style={{ boxShadow: '0px 10px 50px hsla(0, 0%, 0%, 0.33)' }}>
        <StyledModalHeader>{t`FG - Brix`}</StyledModalHeader>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Original Brix (unadjusted)`}</label></Box>
          <Box><StyledInput type='number' value={fgBrix.ob} onChange={e => setFgBrix({ ...fgBrix, ob: parseFloat(e.target.value) })} /></Box>
        </Flex>

        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Final Brix (unadjusted)`}</label></Box>
          <Box><StyledInput type='number' value={fgBrix.fb} onChange={e => setFgBrix({ ...fgBrix, fb: parseFloat(e.target.value) })} /></Box>
        </Flex>

        <Flex mt={4}>
          <Text fontWeight='bold' width='175px'>{t`Final Gravity`}</Text>
          <Text>{Math.round(fgCalc(fgBrix) * 1000) / 1000}</Text>
        </Flex>

        <div className='row-reverse-wrapper'>
          <CloseModalButton onClick={() => props.closeDialogFgPlato()}>{t`Close`}</CloseModalButton>
        </div>
      </DialogContent>
    </DialogOverlay>
  )
}

export default PlatoAlcTool
