import React, { useState } from 'react'
import { t } from 'ttag'
import { StyledModalHeader, StyledInput, CloseModalButton } from '../StyledComponents/Components'
import {
  DialogOverlay,
  DialogContent
} from '@reach/dialog'
import '@reach/dialog/styles.css'
import { Box, Flex, Text } from 'rebass'

function SgPlatoTool (props) {
  const sgChanged = (sgPlato, sg) => {
    const brix = (((182.4601 * sg - 775.6821) * sg + 1262.7794) * sg - 669.5622)
    const plato = brix / 1.04
    setSgPlato({ sg, plato: Math.round(plato * 100) / 100, brix: Math.round(brix * 100) / 100 })
  }

  const brixChanged = (sgPlato, brix) => {
    const plato = brix / 1.04
    const sg = (brix / (258.6 - ((brix / 258.2) * 227.1))) + 1
    setSgPlato({ sg: Math.round(sg * 1000) / 1000, plato: Math.round(plato * 100) / 100, brix })
  }

  const [sgPlato, setSgPlato] = useState({ sg: 1.060, plato: 14.17, brix: 14.74 })

  return (
    <DialogOverlay
      style={{ background: 'hsla(0, 100%, 100%, 0.9)', zIndex: '1000' }}
      isOpen={props.dialogShowSgPlato}
    >
      <DialogContent style={{ boxShadow: '0px 10px 50px hsla(0, 0%, 0%, 0.33)' }}>
        <StyledModalHeader>{t`Sg-Plato-Brix`}</StyledModalHeader>

        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Specific Gravity`}</label></Box>
          <Box><StyledInput type='number' min='0.800' max='100' step='0.001' value={sgPlato.sg} onChange={e => sgChanged(sgPlato, parseFloat(e.target.value))} /></Box>
        </Flex>

        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Brix`}</label></Box>
          <Box><StyledInput type='number' step='0.1' min='1' value={sgPlato.brix} onChange={e => brixChanged(sgPlato, parseFloat(e.target.value))} /></Box>
        </Flex>

        <Flex mt={4}>
          <Text fontWeight='bold' width='175px'>{t`Plato (corrected value)`}</Text>
          <Text>{sgPlato.plato}</Text>
        </Flex>

        <div className='row-reverse-wrapper'>
          <CloseModalButton onClick={() => props.closeDialogSgPlato()}>{t`Close`}</CloseModalButton>
        </div>
      </DialogContent>
    </DialogOverlay>
  )
}

export default SgPlatoTool
