import React from 'react'
import { Input, Dropdown, Button, Icon, Form } from 'semantic-ui-react'
import { t } from 'ttag'

function YeastPanel (props) {
  const showClass = props.showYeastPanel ? 'yeast-panel' : 'display-none'
  const formOptions = [
    {
      text: t`Liquid`,
      value: 'Liquid'
    },
    {
      text: t`Dry`,
      value: 'Dry'
    },
    {
      text: t`Slant`,
      value: 'Slant'
    },
    {
      text: t`Culture`,
      value: 'Culture'
    }
  ]

  return (
    <div className={showClass}>
      <Button icon>
        <Icon name='close' onClick={props.onYeastPanelToggle} />
      </Button>
      <div>
        <Form>
          <Form.Field inline>
            <Input type='text' className='name-input' onChange={(e, data) => props.onYeastChanged('Name updated', e, data)} value={props.ingredient.name} />
          </Form.Field>
        </Form>
        <Button className='open-picker' onClick={props.onPickYeastClicked}>{t`pick ingredient`}</Button>
        <Form>
          <Form.Field inline>
            <div>
              <label>Lab</label>
            </div>
            <Input type='text' onChange={(e, data) => props.onYeastChanged('Lab updated', e, data)} value={props.ingredient.laboratory} />
          </Form.Field>
        </Form>
        <Form>
          <Form.Field inline>
            <div>
              <label>ID</label>
            </div>
            <Input type='text' onChange={(e, data) => props.onYeastChanged('Id updated', e, data)} value={props.ingredient.product_id} />
          </Form.Field>
        </Form>
        <Form>
          <Form.Field inline>
            <div>
              <label>{t`Attenuation`}</label>
            </div>
            <Input type='number' onChange={(e, data) => props.onYeastChanged('Attenuation updated', e, data)} value={props.ingredient.attenuation} min='0' max='100' step='1' />
          </Form.Field>
        </Form>
        <Dropdown selection options={formOptions} onChange={(e, data) => props.onYeastChanged('Form updated', e, data)} value={props.ingredient.form} />
      </div>
      <div className='delete-button delete-editor'>
        <Button onClick={e => props.deleteIngredient('yeast', e)}>{ t`Delete` }</Button>
      </div>
    </div>
  )
}

export default YeastPanel
