import React from 'react'

function YeastsCards (props) {
  return (
    <div className='yeasts-block'>
      {props.recipe.yeasts.map(yeast => (
        <div className='ingredient-card yeast-card' onClick={() => props.onYeastClick(yeast)}>
          <div className='title-card'>{yeast.name} {yeast.product_id}</div>
          <div className='detail-card'>{Math.round(yeast.attenuation * 10) / 10} % attenuation</div>
        </div>
      ))}
    </div>
  )
}

export default YeastsCards
