const generateString = recipe =>
  `<!doctype html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Recipe</title>
</head>
<style>
/* Color scheme inspired by https://evergreen-v4.surge.sh/ */
@media (min-width: 900px) {
  html {
    background-color: #fff;
    color: #084B8A;
  }
}
body {
    max-width: 660px;
    margin:auto;
}

h1, h2, h3 {
    color:#425A70;
}

strong {
    color: #1070CA;
}

/*! Heavily inspired by ReMarkdown 3.0.0 (MIT) https://fvsch.github.io/remarkdown/ */

.remarkdown {
  line-height: 1.5;
  font-family: monospace, monospace;
}

.remarkdown pre,
.remarkdown code,
.remarkdown kbd,
.remarkdown samp {
  font-family: inherit;
}

.remarkdown h1 {
  font-size: inherit;
  margin-top: 2.25em;
  margin-bottom: 1.5em;
}

.remarkdown h2 {
  font-size: inherit;
  margin-top: 2.25em;
  margin-bottom: 1.5em;
}

.remarkdown h3,
.remarkdown h4,
.remarkdown h5,
.remarkdown h6 {
  font-size: inherit;
  margin-top: 1.5em;
  margin-bottom: 1.5em;
}

.remarkdown h1::before {
  content: "# ";
}

.remarkdown h2::before {
  content: "## ";
}

.remarkdown h3::before {
  content: "### ";
}

.remarkdown h4::before {
  content: "#### ";
}

.remarkdown h5::before {
  content: "##### ";
}

.remarkdown h6::before {
  content: "###### ";
}

.remarkdown.h1-underline h1,
.remarkdown.h2-underline h2 {
  display: table;
  overflow: hidden;
  position: relative;
  padding-bottom: 1.5em;
}

.remarkdown.h1-underline h1::before,
.remarkdown.h2-underline h2::before {
  content: none;
}

.remarkdown.h1-underline h1::after,
.remarkdown.h2-underline h2::after {
  position: absolute;
  bottom: 0;
  left: 0;
  height: 1.5em;
  width: 100%;
  overflow: hidden;
  word-break: break-all;
  cursor: default;
}
.remarkdown.h1-underline h1::after {
  content: "========================================================================================================================";
}

.remarkdown.h2-underline h2::after {
  content: "------------------------------------------------------------------------------------------------------------------------";
}

.remarkdown p {
  margin-top: 1.5em;
  margin-bottom: 1.5em;
}

.remarkdown figure {
  margin: 1.5em 0 1.5em;
}

hr {
  height: 1.5em;
  line-height: 1.5em;
  margin: 1.5em 0 1.5em;
  border: none;
  color: inherit;
}

.remarkdown.hr-center hr {
  text-align: center;
}

.remarkdown hr::before {
  content: "* * * *";
}

.remarkdown.hr-hyphen hr::before {
  content: "-------";
}

.remarkdown ul {
  margin: 1.5em 0ch 1.5em 4ch;
  padding: 0;
}

.remarkdown li ul {
  margin-top: 0;
  margin-bottom: 0;
}

.remarkdown.ul-plus ul {
  list-style: none;
}

.remarkdown.ul-plus ul > li::before {
  float: left;
  width: 1ch;
  margin-left: -4ch;
  margin-right: 1ch;
  content: "+";
}

.remarkdown.ul-star ul {
  list-style: none;
}

.remarkdown.ul-star ul > li::before {
  float: left;
  width: 1ch;
  margin-left: -4ch;
  margin-right: 1ch;
  content: "*";
}

.remarkdown ul {
  list-style: none;
}

.remarkdown ul > li::before {
  float: left;
  width: 1ch;
  margin-left: -4ch;
  margin-right: 1ch;
  content: "-";
}

.remarkdown ol {
  margin: 1.5em 0ch 1.5em 4ch;
  padding: 0;
}

.remarkdown li ol {
  margin-top: 0;
  margin-bottom: 0;
}

.remarkdown ol {
  list-style: none;
  counter-reset: rmd-ol;
}

.remarkdown ol > li {
  counter-increment: rmd-ol;
}

.remarkdown ol > li::before {
  float: left;
  margin-left: -4ch;
  margin-right: 1ch;
  min-width: 2ch;
  content: counter(rmd-ol) ".";
}

.remarkdown.ol-zero ol {
  list-style: none;
}

.remarkdown.ol-zero ol > li::before {
  float: left;
  margin-left: -4ch;
  margin-right: 1ch;
  min-width: 2ch;
  content: "0.";
}

.remarkdown.ol-alpha ol {
  list-style: none;
  counter-reset: rmd-ol;
}

.remarkdown.ol-alpha ol > li {
  counter-increment: rmd-ol;
}

.remarkdown.ol-alpha ol > li::before {
  float: left;
  margin-left: -4ch;
  margin-right: 1ch;
  min-width: 2ch;
  content: counter(rmd-ol, lower-alpha) ".";
}

.remarkdown a::before {
  content: "[";
}

.remarkdown a::after {
  content: "]";
}

.remarkdown.a-showurl a[href]::before {
  content: "[";
}

.remarkdown.a-showurl a[href]::after {
  content: "](" attr(href) ")";
  word-break: break-all;
}

.remarkdown em {
  font-style: normal;
  font-weight: normal;
}

.remarkdown em::before,
.remarkdown em::after {
  content: "*";
}

.remarkdown.em-underscore em::before,
.remarkdown.em-underscore em::after {
  content: "_";
}

.remarkdown blockquote {
  margin: 1.5em 2ch 1.5em 2ch;
  padding: 0;
}

.remarkdown blockquote {
  position: relative;
}

.remarkdown blockquote::before {
  position: absolute;
  top: 0;
  left: -2ch;
  bottom: 0;
  width: 1ch;
  overflow: hidden;
  white-space: pre;
  content: ">\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a>\a";
  cursor: default;
}

.remarkdown.del-gfm del {
  text-decoration: none;
}

.remarkdown.del-gfm del::before,
.remarkdown.del-gfm del::after {
  content: "~~";
}

.remarkdown.table-marker table {
  margin-top: 1.5em;
  margin-bottom: 1.5em;
  border-collapse: collapse;
}

.remarkdown.table-marker tr > * {
  min-width: 3ch;
  position: relative;
  padding: 0;
  text-align: inherit;
  vertical-align: top;
  font-weight: normal;
  border: none;
}

.remarkdown.table-marker tr > * + * {
  padding-left: 3ch;
}

.remarkdown.table-marker tr:first-child > th:not([scope="row"]) {
  padding-bottom: 1.5em;
}

.remarkdown.table-marker tr:first-child > th:not([scope="row"])::after {
  content: "--------------------------------------------------------------------------------------------------------------";
  position: absolute;
  bottom: 0;
  left: 0;
  right: 0;
  overflow: hidden;
  word-break: break-all;
  height: 1.5em;
}

.remarkdown.table-marker tr:first-child > * + th:not([scope="row"])::after {
  left: 3ch;
}

.remarkdown.table-marker tr > * + *::before {
  content: "|\a|\a|\a|\a|\a|\a|\a|\a|\a|\a";
  position: absolute;
  overflow: hidden;
  left: 1ch;
  top: 0;
  bottom: 0;
  white-space: pre;
}

</style>
<body class="remarkdown h1-underline h2-underline hr-hyphen">
  <h1>${recipe.name}</h1>
  <i>${recipe.style.name} by ${recipe.brewer}</i>
<hr />
<ul>
<li>Batch size : <strong>${recipe.batch_size} L</strong></li>
<li>Efficiency : <strong>${recipe.efficiency} %</strong></li>
</ul>
<hr />
OG ${recipe.og} | FG ${recipe.fg} | ${recipe.ebc} EBC | ${recipe.ibu} IBU | ABV ${recipe.alc} %
<hr />

<h2>Ingredients</h2>
<h3>Grains & sugars</h3>
<ul>
${recipe.fermentables.map(fermentable => `
<li> ${fermentable.amount} g | ${fermentable.name} (${fermentable.color} EBC, yield ${fermentable.yield} %) </li>
`).join('')}
</ul>

<h3>Hops</h3>
<ul>
${recipe.hops.map(hop => `
<li> ${hop.amount} g | ${hop.name}(&#x3B1;${hop.alpha}%, ${hop.form}) @ ${hop.time} min (${hop.use})</li>
`).join('')}
</ul>

<h3>Miscs</h3>
<ul>
${recipe.miscs.map(misc => `
<li>${misc.amount} g | ${misc.name} (${misc.time} min)</li>
`).join('')}
</ul>

<h3>Yeasts</h3>
<ul>
${recipe.yeasts.map(yeast => `
<li>${yeast.name}  ${yeast.laboratory} ${yeast.product_id} (${yeast.form})</li>
`).join('')}
</ul>

<h2>Notes</h2>
${recipe.notes}

<h2>Mash Profile</h2>
${recipe.mash.name}

<h3>Steps</h3>
<ul>
${recipe.mash.mash_steps.map(step => `
<li>${step.name} (${step.type}) @ ${step.step_temp} - ${step.step_time} min </li>`).join('')}
</ul>
</body>
</html>
`

export { generateString as default }
