const generateString = recipe =>

`# ${recipe.name}

*${recipe.style.name} by ${recipe.brewer}*

---
Batch size : **${recipe.batch_size} L**
Efficiency : **${recipe.efficiency} %**

---
OG ${recipe.og} | FG ${recipe.fg} | ${recipe.ebc} EBC | ${recipe.ibu} IBU | ABV ${recipe.alc} %
---


## Ingredients

### Grains & sugars
${recipe.fermentables.map(fermentable => `
* ${fermentable.amount} g | ${fermentable.name} (${fermentable.color} EBC, yield ${fermentable.yield} %)`).join('')}

### Hops
${recipe.hops.map(hop => `
* ${hop.amount} g | ${hop.name}(α${hop.alpha}%, ${hop.form}) @ ${hop.time} min (${hop.use})`).join('')}

### Miscs
${recipe.miscs.map(misc => `
* ${misc.amount} g | ${misc.name} (${misc.time} min)`).join('')}

### Yeasts
${recipe.yeasts.map(yeast => `
* ${yeast.name} - ${yeast.laboratory} ${yeast.product_id} (${yeast.form})`).join('')}

## Notes
${recipe.notes}

## Mash Profile
${recipe.mash.name}

### Steps
${recipe.mash.mash_steps.map(step => `
* ${step.name} (${step.type}) @ ${step.step_temp} - ${step.step_time} min`).join('')}
`;

export { generateString as default };
