
const electron = require('electron')
const _ = require('underscore')
// Module to control application life.
const { app } = electron
// Module to create native browser window.
const { BrowserWindow } = electron
const nanoid = require('nanoid')
const os = require('os')
const fs = require('fs-extra')
const ini = require('ini')
const path = require('path')
// const url = require('url')
const { ipcMain } = require('electron')
// const dialog = electron.dialog
const XML = require('pixl-xml')
const bffFile = require('./BFF.json')

// Keep a global reference of the window object, if you don't, the window will
// be closed automatically when the JavaScript object is garbage collected.
let mainWindow

const isDev = process.env.NODE_ENV === 'development'

// if (isDev) {
//   config = require('../build/config')
// } else {
//   config = {}
// }

function createWindow () {
  // Create the browser window.
  mainWindow = new BrowserWindow({
    width: 1200,
    height: 700,
    minWidth: 850,
    icon: path.join(__dirname, '../assets/icon.png'),
    webPreferences: {
      nodeIntegration: true
    }
  })
  mainWindow.setMenuBarVisibility(false)
  mainWindow.setMenu(null)

  // and load the index.html of the app.
  mainWindow.loadURL(isDev ? 'http://localhost:3000' : `file://${path.join(__dirname, '../build/index.html')}`)

  // Open the DevTools.
  if (isDev) {
    mainWindow.webContents.openDevTools()

    // const installExtension = require('electron-devtools-installer')
    // installExtension.default(installExtension.VUEJS_DEVTOOLS)
    //   .then(name => console.log(`Added Extension:  ${name}`))
    //   .catch(err => console.log('An error occurred: ', err))
  }

  // Emitted when the window is closed.
  mainWindow.on('closed', () => {
    // Dereference the window object, usually you would store windows
    // in an array if your app supports multi windows, this is the time
    // when you should delete the corresponding element.
    mainWindow = null
  })
}

// This method will be called when Electron has finished
// initialization and is ready to create browser windows.
// Some APIs can only be used after this event occurs.
app.on('ready', () => {
  // if (process.env.NODE_ENV !== 'production') {
  //   require('vue-devtools').install()
  // }
  //  use .uninstall to uninstall
  createWindow()
})

// Quit when all windows are closed.
app.on('window-all-closed', () => {
  // On OS X it is common for applications and their menu bar
  // to stay active until the user quits explicitly with Cmd + Q
  app.quit()
})

app.on('activate', () => {
  // On OS X it's common to re-create a window in the app when the
  // dock icon is clicked and there are no other windows open.
  if (mainWindow === null) {
    createWindow()
  }
})

// In this file you can include the rest of your app's specific main process
// code. You can also put them in separate files and require them here.

function walkRecipes (dir) {
  return fs.readdirSync(dir).reduce((list, file) => {
    const name = path.join(dir, file)
    const isDir = fs.statSync(name).isDirectory()
    return list.concat(isDir ? walkRecipes(name) : [name])
  }, [])
}

function parseFile (filePath) {
  const rawXml = fs.readFileSync(filePath, 'utf8')
  try {
    const rawObject = XML.parse(rawXml, { lowerCase: true }).recipe
    return rawObject
  } catch (err) {
    console.log('XML parser error : ' + err)
  }
}

function parseFiles (listFiles) {
  return listFiles.reduce((list, filePath) => {
    const recipeObject = parseFile(filePath)
    if (typeof recipeObject !== 'undefined') {
      recipeObject.path = filePath
      return list.concat([recipeObject])
    }
    return list
  }, [])
}

function parseAll (f, dirStorage) {
  // First we need a list of paths.
  // f is the function used to read each directory inside dirStorage.
  const listFiles = f(dirStorage)
  return parseFiles(listFiles)
}

function recipesList (recipes) {
  // parse all recipes recursively
  // const recipes = parseAll(walkRecipes, recipesDir)

  function consolidate (recipe) {
    if (!recipe.miscs || !recipe.miscs.length) {
      recipe.miscs = []
    } else if (!recipe.fermentables || !recipe.fermentables.length) {
      recipe.fermentables = []
    } else if (!recipe.hops || !recipe.hops.length) {
      recipe.hops = []
    } else if (!recipe.yeasts || !recipe.yeasts.length) {
      recipe.yeasts = []
    }
    return recipe
  }

  // cleaning ingredients arrays.
  function flatten (recipe) {
    // recipe.fermentables.fermentable : [] ---> recipe.fermentables : []
    // if only 1 fermentable,
    //
    // recipe.fermentables.fermentable : fermentable ---> recipe.fermentables : [fermentable]
    // if 0 fermentable ---> []
    const fermentablesArray = []
    if (recipe.fermentables.fermentable instanceof Array) {
      recipe.fermentables.fermentable.map((item) => fermentablesArray.push(item))
    } else {
      fermentablesArray.push(recipe.fermentables.fermentable)
    }
    recipe.fermentables = (fermentablesArray[0] == null) ? [] : fermentablesArray

    const hopsArray = []
    if (recipe.hops.hop instanceof Array) {
      recipe.hops.hop.map((item) => hopsArray.push(item))
    } else {
      hopsArray.push(recipe.hops.hop)
    }
    recipe.hops = (hopsArray[0] == null) ? [] : hopsArray

    const miscsArray = []
    if (recipe.miscs.misc instanceof Array) {
      recipe.miscs.misc.map((item) => miscsArray.push(item))
    } else {
      miscsArray.push(recipe.miscs.misc)
    }
    recipe.miscs = (miscsArray[0] == null) ? [] : miscsArray

    const yeastsArray = []
    if (recipe.yeasts.yeast instanceof Array) {
      recipe.yeasts.yeast.map((item) => yeastsArray.push(item))
    } else {
      yeastsArray.push(recipe.yeasts.yeast)
    }
    recipe.yeasts = (yeastsArray[0] == null) ? [] : yeastsArray

    const stepsArray = []
    if (recipe.mash.mash_steps.mash_step instanceof Array) {
      recipe.mash.mash_steps.mash_step.map((item) => stepsArray.push(item))
    } else {
      stepsArray.push(recipe.mash.mash_steps.mash_step)
    }
    recipe.mash.mash_steps = (stepsArray[0] == null) ? [] : stepsArray

    return recipe
  }

  function fixAmounts (recipe) {
    const toGrams = (item) => { item.amount *= 1000; return item }
    recipe.fermentables = recipe.fermentables.map(toGrams)
    recipe.hops = recipe.hops.map(toGrams)
    recipe.miscs = recipe.miscs.map(toGrams)
    return recipe
  }

  function fixNumbers (recipe) {
    recipe.batch_size = parseFloat(recipe.batch_size)
    recipe.efficiency = parseFloat(recipe.efficiency)
    recipe.boil_time = parseFloat(recipe.boil_time)
    recipe.fermentables.map((item) => {
      item.amount = parseFloat(item.amount)
      item.yield = parseFloat(item.yield)
      item.color = parseFloat(item.color)
    })
  }

  function fixColor (recipe) {
    const toEbc = (item) => { item.color = item.color * 1.97; return item }
    recipe.fermentables = recipe.fermentables.map(toEbc)
    return recipe
  }

  function fixFermentableUse (recipe) {
    const addDefault = (item) => {
      if (item.add_after_boil === 'TRUE') {
        item.use = 'add_to_flameout'
        return item
      }
      item.use = 'add_to_mash'
      return item
    }
    const checkUse = item => item.use ? item : addDefault(item)
    recipe.fermentables = recipe.fermentables.map(checkUse)
    return recipe
  }

  function fixHopUse (recipe) {
    const aromaToFlameout = (item) => {
      const newUse = (item.use === 'Aroma') ? 'Flame Out' : item.use
      item.use = newUse
      return item
    }
    recipe.hops = recipe.hops.map(aromaToFlameout)
    return recipe
  }

  function sortHops (recipe) {
    const groupHops = use => recipe.hops.filter(hop => hop.use === use)
    recipe.hops = [].concat(
      _.sortBy(groupHops('Mash'), 'time').reverse(),
      _.sortBy(groupHops('First Wort'), 'time').reverse(),
      _.sortBy(groupHops('Boil'), 'time').reverse(),
      _.sortBy(groupHops('Flame Out'), 'time').reverse(),
      _.sortBy(groupHops('Dry Hop'), 'time').reverse()
    )
    return recipe
  }

  function addId (recipe) {
    const appendId = (item) => {
      const newItem = item
      newItem.id = nanoid()
      newItem.nameId = nanoid()
      return newItem
    }
    recipe.fermentables.map(fermentable => appendId(fermentable))
    recipe.hops.map(hop => appendId(hop))
    recipe.miscs.map(misc => appendId(misc))
    recipe.yeasts.map(yeast => appendId(yeast))
  }

  recipes.map(consolidate)
  recipes.map((recipe) => {
    const newRecipe = recipe
    newRecipe.id = nanoid()
    return newRecipe
  })
  recipes.map(flatten)
  recipes.map(fixAmounts)
  recipes.map(fixNumbers)
  recipes.map(fixColor)
  recipes.map(fixFermentableUse)
  recipes.map(fixHopUse)
  recipes.map(addId)

  recipes.map(sortHops)

  return recipes
}

const pathConfig = () => {
  if (os.platform() === 'darwin') {
    return path.join(os.homedir(), '/.config/joliebulle/joliebulle4.conf')
  } else if (os.platform() === 'win32') {
    return path.join(os.homedir(), '/AppData/Local/joliebulle/joliebulle4.conf')
  }
  return path.join(os.homedir(), '/.config/joliebulle/joliebulle4.conf')
}

const defaultPath = () => {
  if (os.platform() === 'win32') {
    return path.join(os.homedir(), '/AppData/Local/joliebulle/recettes')
  }
  return path.join(os.homedir(), '/.config/joliebulle/recettes')
}

const checkConfig = () => {
  const globalPathConfig = () => {
    if (os.platform() === 'win32') {
      return path.join(os.homedir(), '/AppData/Local/joliebulle/joliebulle4.conf')
    }
    return path.join(os.homedir(), '/.config/joliebulle/joliebulle4.conf')
  }

  const newConfig = () => {
    const conf = {
      General: {
        BoilOffRate: 10,
        CoolingLoss: 5,
        GrainTemp: 20,
        FudgeFactor: 1.7,
        GrainRetention: 1,
        path: defaultPath()
      }
    }
    return conf
  }

  if (!(fs.existsSync(globalPathConfig()))) {
    fs.writeFileSync(globalPathConfig(), ini.stringify(newConfig()))
  }
}

const iniConfig = () => {
  checkConfig()
  const defaultConfig = {
    General: {
      BoilOffRate: 10,
      CoolingLoss: 5,
      GrainTemp: 20,
      FudgeFactor: 1.7,
      GrainRetention: 1,
      path: defaultPath()
    }
  }
  try {
    const readConfig = ini.parse(fs.readFileSync(pathConfig(), 'utf-8'))
    return readConfig
  } catch (e) {
    const readConfig = defaultConfig
    return readConfig
  }
}

// const mashProfiles = (pathMash) => {
//   const appendId = (item) => {
//     const newItem = item
//     newItem.id = nanoid()
//     return newItem
//   }
//   function flatten (profile) {
//     const stepsArray = []
//     if (profile.mash_steps.mash_step instanceof Array) {
//       profile.mash_steps.mash_step.map(item => stepsArray.push(item))
//     } else {
//       stepsArray.push(profile.mash_steps.mash_step)
//     }
//     profile.mash_steps = (stepsArray[0] == null) ? [] : stepsArray
//     return profile
//   }

//   const parsedProfiles = XML.parse(fs.readFileSync(pathMash, 'utf8'), { lowerCase: true }).mash
//   return parsedProfiles.map((profile) => {
//     // const newProfile = { ...profile };
//     const newProfile = flatten(profile)
//     newProfile.id = nanoid()
//     newProfile.mash_steps.map(step => appendId(step))
//     return newProfile
//   })
// }

const ingredients = (pathIngs) => {
  const appendId = (item) => {
    const newItem = item
    newItem.id = nanoid()
    return newItem
  }
  const parsedObject = XML.parse(fs.readFileSync(pathIngs, 'utf8'), { lowerCase: true })
  return {
    fermentables: _.sortBy(parsedObject.fermentable.map(item => appendId(item)), 'name'),
    hops: _.sortBy(parsedObject.hop.map(item => appendId(item)), 'name'),
    miscs: _.sortBy(parsedObject.misc.map(item => appendId(item)), 'name'),
    yeasts: _.sortBy(parsedObject.yeast.map(item => appendId(item)), 'name')
  }
}

const pathFolder = () => {
  if (os.platform() === 'win32') {
    return path.join(os.homedir(), '/AppData/Local/joliebulle')
  }
  return path.join(os.homedir(), '/.config/joliebulle')
}

// const pathProfiles = () => {
//   if (os.platform() === 'win32') {
//     return path.join(os.homedir(), '/AppData/Local/joliebulle/mash.xml')
//   }
//   return path.join(os.homedir(), '/.config/joliebulle/mash.xml')
// }

const pathIngredients = () => {
  if (os.platform() === 'win32') {
    return path.join(os.homedir(), '/AppData/Local/joliebulle/database.xml')
  }
  return path.join(os.homedir(), '/.config/joliebulle/database.xml')
}

const pathRecipes = () => {
  if (os.platform() === 'win32') {
    const fallbackPath = path.join(os.homedir(), '/AppData/Local/joliebulle/recettes')
    return iniConfig().General.path ? iniConfig().General.path : fallbackPath
  }
  const fallbackPath = path.join(os.homedir(), '/.config/joliebulle/recettes')
  return iniConfig().General.path ? iniConfig().General.path : fallbackPath
}

const pathBFF = () => {
  if (os.platform() === 'win32') {
    return path.join(os.homedir(), '/AppData/Local/joliebulle/BFF.json')
  }
  return path.join(os.homedir(), '/.config/joliebulle/BFF.json')
}

const checkBFF = () => {
  if (fs.existsSync(pathBFF())) {
    return true
  }
  return false
}

const loadFallback = () => {
  // let rawdata = fs.readFileSync(bffFile)
  return bffFile
}

const loadBFF = () => {
  return JSON.parse(fs.readFileSync(pathBFF(), 'utf8'))
}

const createBFF = () => {
  // return fs.appendFileSync(pathBFF(), JSON.stringify(loadFallback()), 'utf8')
  fs.ensureDirSync(pathFolder())
  return fs.appendFileSync(pathBFF(), JSON.stringify(loadFallback()), 'utf8')
  // return fs.closeSync(fs.openSync(JSON.stringify(pathBFF()), 'w'))
}

const initBFF = () => {
  if (checkBFF()) {
    return loadBFF()
  }
  createBFF()
  return loadFallback()
}

ipcMain.on('load', () => {
  // const jsonList = recipesList(pathRecipes())
  // console.log(JSON.stringify(jsonList))
  // mainWindow.webContents.send('initRecipes', {
  //   recipes: jsonList,
  //   config: iniConfig(),
  //   mash_profiles: mashProfiles(pathProfiles()),
  //   ingredients: ingredients(pathIngredients())
  // })
  mainWindow.webContents.send('initRecipes', initBFF())
})

ipcMain.on('importLegacyDirectory', event => {
  const recipes = recipesList(parseAll(walkRecipes, pathRecipes()))
  mainWindow.webContents.send('recipesLegacyJson', recipes)
})

ipcMain.on('writeBFF', (event, data) => {
  fs.writeFileSync(pathBFF(), JSON.stringify(data))
})

ipcMain.on('importFiles', (event, paths) => {
  if (paths !== null) {
    mainWindow.webContents.send('recipesJson',
      recipesList(parseFiles(paths))
    )
  }
})

ipcMain.on('importIngredients', event => {
  mainWindow.webContents.send('ingredientsJson', ingredients(pathIngredients()))
})

// ipcMain.on('writeConfig', (event, conf) => {
//   const newConf = conf
//   fs.writeFileSync(pathConfig(), ini.stringify(newConf))
// })

ipcMain.on('writeRecipe', (event, stringXml) => {
  const temporaryPath = path.join(os.homedir(), 'essai.xml')
  fs.writeFileSync(temporaryPath, stringXml)
})

ipcMain.on('restoreDatabase', event => {
  mainWindow.webContents.send('originalIngredients', bffFile.ingredients)
})

ipcMain.on('print', event => {
  mainWindow.webContents.print({ silent: false, printBackground: false, deviceName: '' })
})
