import React, { useState, useEffect } from 'react'
import {
  DialogOverlay,
  DialogContent
} from '@reach/dialog'
import '@reach/dialog/styles.css'
import { t } from 'ttag'
import styled from 'styled-components/macro'
import { Box, Text, Flex } from 'rebass'

import { Icon, Form } from 'semantic-ui-react'

const CloseModalButton = styled.button`
  border:none;
  border-radius: 5px;
  margin-top:15px;
 
  padding:8px;
  color:#fff;
  background-color:#1070CA;

  :hover {
    background-color:#084B8A;
  }
`
const StyledInput = styled.input`
border: solid 1px #E4E7EB;
height:32px;
width:100px;
fontSize: 16px;
color: #425A70;
padding-left:10px;
`
const StyledModalHeader = styled.div`
position:relative;
top:0;
padding-left:0;
padding-right:0;
padding-bottom:10px;
margin-right:-28px;
margin-left:-28px;
margin-bottom:48px;
margin-top:-15px;
text-transform:uppercase;
border-bottom: solid 1px #E4E7EB;
text-align:center;
`

const StyledButtonLink = styled.button`
background:#e5eff9;
border:none;
border-radius:5px;
color: #1070CA;
padding:8px;
margin-left:0;
margin-top:15px;
font-family : 'robotomedium';
text-align:left;
width:90px;
`

const calcSG = (props, e) => {
  const ratio = (props.recipe.preboilVolume / parseFloat(e.target.value))
  const gu = (props.recipe.preboilGravity - 1) * ratio
  return (1 + gu)
}

const calcCorrectedSG = (measuredSG, temp) => {
  const correction = ((measuredSG - (20 + 288.9414) / (508929.2 * (20 + 68.12963)) * Math.pow((20 - 3.9863), 2)) / (1 - (temp + 288.9414) / (508929.2 * (temp + 68.12963)) * Math.pow((temp - 3.9863), 2))) - measuredSG
  return (measuredSG - correction).toFixed(3)
}

function BiabMode (props) {
  const [dialogShow, setDialogShow] = useState(false)
  const [calculatedSG, setSG] = useState(props.recipe.preboilGravity)
  useEffect(() => {
    setSG(props.recipe.preboilGravity)
  }, [props.recipe.preboilGravity])
  const [correctedSG, setCorrected] = useState(calcCorrectedSG(calculatedSG, 50))

  return (
    <div className='biab column-wrapper display-block'>
      <div className='row-wrapper'>
        <div className='biabTargetTemp'>
          <div>{ t`Target` }</div>
          <Form className='fluid' size='tiny'>
            <Form.Input id='inputTargetTemp' onChange={props.handleBiabTargetChange} defaultValue={props.biab.targetTemp} type='number' />
          </Form>
          <div>°C</div>
        </div>
        <Icon name='long arrow alternate right' size='large' />
        <div className='biabWaterTemp'>
          <div className='brewday-item'>{ t`Water` }</div>
          <div className='medium-text'> {Math.round(props.biab.temp * 10) / 10} </div>
          <div>°C</div>
        </div>
        <div className='biabStrike'>
          <div className='brewday-item'>{ t`Add` }</div>
          <div className='medium-text'> {Math.round(props.biab.strikeVol * 10) / 10}</div>
          <div>L</div>
        </div>
        <div className='biabRatio'>
          <div className='brewday-item'>{ t`Ratio` } </div>
          <div className='medium-text'> {Math.round(props.biab.ratio * 10) / 10} </div>
          <div>(L/kg)</div>
        </div>
      </div>
      <Flex>
        <Box bg='#F9F9FB' p={25} ml={15} width={1 / 3}>
          <Text fontWeight='bold' mb={15}>{ t`Pre-boil targets` }</Text>
          <Flex>
            <Text>{ t`Preboil volume (calculated)` } : &nbsp; </Text>
            <Text>{ Math.round(props.recipe.preboilVolume * 10) / 10} L</Text>
          </Flex>
          <Flex>
            <Text>{ t`Preboil gravity (calculated)` } : &nbsp;</Text>
            <Text> {Math.round(props.recipe.preboilGravity * 1000) / 1000}</Text>
          </Flex>
          <StyledButtonLink onClick={() => setDialogShow(true)}><Icon name='exchange' />{t`Check`}</StyledButtonLink>
          <DialogOverlay
            style={{ background: 'hsla(0, 100%, 100%, 0.9)', zIndex: '1000' }}
            isOpen={dialogShow}
          >
            <DialogContent style={{ boxShadow: '0px 10px 50px hsla(0, 0%, 0%, 0.33)' }}>
              <StyledModalHeader>{t`Check pre-boil gravity`}</StyledModalHeader>
              <label style={{ paddingRight: '25px' }}>{t`If`} <span className='bold'>{t`measured pre-boil volume`}</span> {t`is`} </label>
              <StyledInput id='volume' defaultValue={Math.round(props.recipe.preboilVolume * 10) / 10} onChange={e => setSG(calcSG(props, e))} type='number' /> L
              <div style={{ marginTop: '32px' }}>{t`then`} <span className='bold'>{t`Specific Gravity`}</span> {t`should be :`}<span style={{ paddingLeft: '25px' }}>{Math.round(calculatedSG * 1000) / 1000}</span><span style={{ paddingLeft: '25px' }}>@ 20°C</span></div>
              <div style={{ marginTop: '32px' }}>
                <span style={{ paddingRight: '25px' }}>{t`or`}</span> <span>{correctedSG}</span> @ <StyledInput id='temp' defaultValue={50} onChange={e => setCorrected(calcCorrectedSG(calculatedSG, parseFloat(e.target.value)))} type='number' /> °C
              </div>

              <div className='row-reverse-wrapper'>
                <CloseModalButton onClick={() => setDialogShow(false)}>{t`Close`}</CloseModalButton>
              </div>
            </DialogContent>
          </DialogOverlay>
        </Box>
        <Box bg='#F9F9FB' p={25} ml={15} width={1 / 3}>
          <Text fontWeight='bold' mb={15}>{ t`Volumes` }</Text>
          <div>
            <span className='brewday-item'> { t`Grain Volume` } : </span>
            {Math.round(props.recipe.grainVolume * 10) / 10} L
          </div>
          <div>
            <span className='brewday-item'>{ t`Mash volume (first step)` } : </span>
            {Math.round(props.biab.mashVolume * 10) / 10} L
          </div>
        </Box>
      </Flex>
    </div>
  )
}

export default BiabMode
