import React from 'react'
import { t } from 'ttag'

function FermentablesCards (props) {
  const display = use =>
    use === 'add_to_mash' ? t`Mash`
      : use === 'add_to_boil' ? t`Boil`
        : use === 'add_to_flameout' ? t`Flame Out`
          : use === 'add_to_fermentation' ? t`Fermentation`
            : use === 'add_to_package' ? t`Package`
              : t`mash`

  return (
    <div className='fermentables-block'>
      {props.recipe.fermentables.map(fermentable => (
        <div className='ingredient-card fermentable-card' onClick={() => props.onFermentableClick(fermentable)}>
          <div className='title-card'><div>{fermentable.name}</div><div className='amount'>{Math.round(fermentable.amount)} g</div></div>
          <div className='detail-card'><div>{display(fermentable.use)}</div> <div>{Math.round(fermentable.amountRatio * 1000) / 10} %</div> </div>
        </div>
      ))}
    </div>
  )
}

export default FermentablesCards
