import React from 'react'
import { Input, Dropdown, Button, Icon, Form } from 'semantic-ui-react'
import { t } from 'ttag'

function HopPanel (props) {
  const showClass = props.showHopPanel ? 'hop-panel' : 'display-none'
  const formOptions = [
    {
      text: t`Leaf`,
      value: 'Leaf'
    },
    {
      text: t`Pellet`,
      value: 'Pellet'
    },
    {
      text: t`Plug`,
      value: 'Plug'
    }
  ]
  const useOptions = [
    {
      text: t`Boil`,
      value: 'Boil'
    },
    {
      text: t`Dry Hop`,
      value: 'Dry Hop'
    },
    {
      text: t`First Wort`,
      value: 'First Wort'
    },
    {
      text: t`Flame Out`,
      value: 'Flame Out'
    }
  ]
  return (
    <div className={showClass}>
      <Button icon>
        <Icon name='close' onClick={props.onHopPanelToggle} />
      </Button>
      <div>
        <Form>
          <Form.Field inline>
            <Input type='text' className='name-input' onChange={(e, data) => props.onHopChanged('Name updated', e, data)} value={props.ingredient.name} />
          </Form.Field>
        </Form>
        <Button className='open-picker' onClick={props.onPickHopClicked}>{t`pick ingredient`}</Button>
        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Amount (g)` }</label>
            </div>
            <Input type='number' onChange={(e, data) => props.onHopChanged('Amount updated', e, data)} value={props.ingredient.amount} min='0' step='1' />
          </Form.Field>
          <div class='ibu-part-panel'>{Math.round(props.ingredient.ibuPart * 10) / 10} IBU</div>
        </Form>
        {props.ingredient.use !== 'Dry Hop'
          ? <Form>
            <Form.Field inline>
              <div>
                <label>{ t`Time (min)` }</label>
              </div>
              <Input type='number' onChange={(e, data) => props.onHopChanged('Time updated', e, data)} value={props.ingredient.time} min='0' step='1' />
            </Form.Field>
          </Form>
          : <div />}

        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Alpha (%)` }</label>
            </div>
            <Input type='number' onChange={(e, data) => props.onHopChanged('Alpha updated', e, data)} value={props.ingredient.alpha} min='0' max='100' step='1' />
          </Form.Field>
        </Form>
        <Dropdown selection options={formOptions} onChange={(e, data) => props.onHopChanged('Form updated', e, data)} value={props.ingredient.form} />
        <Dropdown selection options={useOptions} onChange={(e, data) => props.onHopChanged('Use updated', e, data)} value={props.ingredient.use} />

        {props.ingredient.use === 'Dry Hop'
          ? <Form>
            <Form.Group widths='equal'>
              <Form.Input fluid label={t`from day`} type='number' onChange={(e, data) => props.onHopChanged('SlotA updated', e, data)} value={props.ingredient.slotA} min='0' step='1' />
              <Form.Input fluid label={t`to day`} type='number' onChange={(e, data) => props.onHopChanged('SlotB updated', e, data)} value={props.ingredient.slotB} min='0' step='1' />
            </Form.Group>
          </Form>
          : <div />}

      </div>
      <div className='delete-button delete-editor'>
        <Button onClick={e => props.deleteIngredient('hop', e)}>{ t`Delete` }</Button>
      </div>
    </div>
  )
}

export default HopPanel
