import React from 'react'
import { Input, Dropdown, Button, Icon, Form } from 'semantic-ui-react'
import { t } from 'ttag'

function MiscPanel (props) {
  const showClass = props.showMiscPanel ? 'misc-panel' : 'display-none'
  const typeOptions = [
    {
      text: t`Spice`,
      value: 'Spice'
    },
    {
      text: t`Fining`,
      value: 'Fining'
    },
    {
      text: t`Water agent`,
      value: 'Water agent'
    },
    {
      text: t`Herb`,
      value: 'Herb'
    },
    {
      text: t`Flavor`,
      value: 'Flavor'
    },
    {
      text: t`Other`,
      value: 'Other'
    }
  ]
  const useOptions = [
    {
      text: t`Boil`,
      value: 'Boil'
    },
    {
      text: t`Mash`,
      value: 'Mash'
    },
    {
      text: t`Primary`,
      value: 'Primary'
    },
    {
      text: t`Secondary`,
      value: 'Secondary'
    },
    {
      text: t`Bottling`,
      value: 'Bottling'
    }
  ]
  return (
    <div className={showClass}>
      <Button icon>
        <Icon name='close' onClick={props.onMiscPanelToggle} />
      </Button>
      <div>
        <Form>
          <Form.Field inline>
            <Input type='text' className='name-input' onChange={(e, data) => props.onMiscChanged('Name updated', e, data)} value={props.ingredient.name} />
          </Form.Field>
        </Form>
        <Button className='open-picker' onClick={props.onPickMiscClicked}>{ t`pick ingredient`}</Button>
        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Amount (g)` }</label>
            </div>
            <Input type='number' onChange={(e, data) => props.onMiscChanged('Amount updated', e, data)} value={props.ingredient.amount} min='0' step='0.1' lang='en-US' />
          </Form.Field>
        </Form>
        <Form>
          <Form.Field inline>
            <div>
              <label>{ t`Time (min)` }</label>
            </div>
            <Input type='number' onChange={(e, data) => props.onMiscChanged('Time updated', e, data)} value={props.ingredient.time} min='0' step='1' />
          </Form.Field>
        </Form>
        <Dropdown selection options={typeOptions} onChange={(e, data) => props.onMiscChanged('Type updated', e, data)} value={props.ingredient.type} />
        <Dropdown selection options={useOptions} onChange={(e, data) => props.onMiscChanged('Use updated', e, data)} value={props.ingredient.use} />

      </div>
      <div className='delete-button delete-editor'>
        <Button onClick={e => props.deleteIngredient('misc', e)}>{ t`Delete` }</Button>
      </div>
    </div>
  )
}

export default MiscPanel
