import React from 'react'
import { t } from 'ttag'
import { Icon, Form, TextArea } from 'semantic-ui-react'

function NotesCard (props) {
  return (
    <div className='notes'>
      <div className='notes-title'><Icon circular inverted size='small' name='sticky note' /> { t`Notes` }</div>
      <div className='notes-block'>
        <Form>
          <TextArea fluid='true' autoHeight placeholder='Add some notes...' value={props.recipe.notes} onChange={e => props.onNotesChanged(e)} />
        </Form>
      </div>
    </div>
  )
}

export default NotesCard
