import React, { useState } from 'react'
import { t } from 'ttag'
import { StyledModalHeader, StyledInput, CloseModalButton } from '../StyledComponents/Components'
import {
  DialogOverlay,
  DialogContent
} from '@reach/dialog'
import '@reach/dialog/styles.css'
import { Box, Text, Flex } from 'rebass'

function AlcoolTool (props) {
  const alcoholCalc = (alcohol) => {
    const abv = ((((alcohol.og - alcohol.fg) * 1.05) / alcohol.fg) * 100) / 0.795 + ((alcohol.sugar * 0.5) / 0.795) / 10
    const atten = 100 * (alcohol.og - alcohol.fg) / (alcohol.og - 1)
    return { abv, atten }
  }
  const [alcohol, setAlcohol] = useState({ og: 1.001, fg: 1.001, sugar: 0 })

  return (
    <DialogOverlay
      style={{ background: 'hsla(0, 100%, 100%, 0.9)', zIndex: '1000' }}
      isOpen={props.dialogShowAlc}
    >
      <DialogContent style={{ boxShadow: '0px 10px 50px hsla(0, 0%, 0%, 0.33)' }}>
        <StyledModalHeader>{t`Alcool by vol`}</StyledModalHeader>

        <Flex mb={2}>
          <Box pr={4} width='175px' ><label>{t`Original Gravity`}</label></Box>
          <Box><StyledInput type='number' min='0.600' max='100' step='0.001' value={alcohol.og} onChange={e => setAlcohol({ ...alcohol, og: parseFloat(e.target.value) })} /></Box>
        </Flex>

        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Final Gravity`}</label></Box>
          <Box><StyledInput type='number' min='0.800' max='100' step='0.001' value={alcohol.fg} onChange={e => setAlcohol({ ...alcohol, fg: parseFloat(e.target.value) })} /></Box>
        </Flex>

        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Added sugar (g/l)`}</label></Box>
          <Box><StyledInput type='number' value={alcohol.sugar} onChange={e => setAlcohol({ ...alcohol, sugar: parseFloat(e.target.value) })} /></Box>
        </Flex>

        <Flex mt={4}>
          <Text fontWeight='bold' width='175px'>{t`Alcohol by vol (%)`}</Text>
          <Text>{Math.round(alcoholCalc(alcohol).abv * 10) / 10}</Text>
        </Flex>
        <Flex>
          <Text fontWeight='bold' width='175px'>{t`Apparent attenuation`}</Text>
          <Text>{Math.round(alcoholCalc(alcohol).atten * 10) / 10}</Text>
        </Flex>

        <div className='row-reverse-wrapper'>
          <CloseModalButton onClick={() => props.closeDialogAlc()}>{t`Close`}</CloseModalButton>
        </div>
      </DialogContent>
    </DialogOverlay>
  )
}

export default AlcoolTool
