import React, { useState } from 'react'
import { t } from 'ttag'
import { StyledModalHeader, StyledInput, CloseModalButton } from '../StyledComponents/Components'
import {
  DialogOverlay,
  DialogContent
} from '@reach/dialog'
import '@reach/dialog/styles.css'
import { Box, Text, Flex } from 'rebass'

const volBoilOff = (boiloff) => boiloff.preboilVolume * (boiloff.boilOffRate / 100) * (boiloff.boilTime / 60)
const volPost = (boiloff) => boiloff.preboilVolume - volBoilOff(boiloff)
const volCoolingLoss = (boiloff) => volPost(boiloff) * boiloff.coolingLoss / 100
const calcBoiloff = (boiloff) => {
  const finalVol = (boiloff) => volPost(boiloff) - volCoolingLoss(boiloff)
  const finalSg = (boiloff) => ((boiloff.preboilGravity * boiloff.preboilVolume) - (volBoilOff(boiloff) + volCoolingLoss(boiloff))) / finalVol(boiloff)
  return { finalVol: finalVol(boiloff), finalSg: finalSg(boiloff) }
}

function BoiloffTool (props) {
  const [boiloff, setBoiloff] = useState({ preboilVolume: 10, preboilGravity: 1.065, boilOffRate: 10, boilTime: 60, coolingLoss: 5 })
  return (
    <DialogOverlay
      style={{ background: 'hsla(0, 100%, 100%, 0.9)', zIndex: '1000' }}
      isOpen={props.dialogShowBoiloff}
    >
      <DialogContent style={{ boxShadow: '0px 10px 50px hsla(0, 0%, 0%, 0.33)' }}>
        <StyledModalHeader>{t`Boil Off`}</StyledModalHeader>

        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Preboil Volume (L)`}</label></Box>
          <Box><StyledInput type='number' min='1' step='1' value={boiloff.preboilVolume} onChange={e => setBoiloff({ ...boiloff, preboilVolume: parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Preboil Gravity`}</label></Box>
          <Box><StyledInput type='number' min='0.800' max='100' step='0.001' value={boiloff.preboilGravity} onChange={e => setBoiloff({ ...boiloff, preboilGravity: parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Boil off rate (%/h)`}</label></Box>
          <Box><StyledInput type='number' min='1' step='1' value={boiloff.boilOffRate} onChange={e => setBoiloff({ ...boiloff, boilOffRate: parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Boil time (min)`}</label></Box>
          <Box><StyledInput type='number' min='1' step='1' value={boiloff.boilTime} onChange={e => setBoiloff({ ...boiloff, boilTime: parseFloat(e.target.value) })} /></Box>
        </Flex>
        <Flex mb={2}>
          <Box pr={4} width='175px'><label>{t`Cooling losses (%)`}</label></Box>
          <Box><StyledInput type='number' min='1' step='1' value={boiloff.coolingLoss} onChange={e => setBoiloff({ ...boiloff, coolingLoss: parseFloat(e.target.value) })} /></Box>
        </Flex>

        <Flex mt={4}>
          <Text fontWeight='bold' width='175px'>{t`Final Volume (L)`}</Text>
          <Text>{Math.round(calcBoiloff(boiloff).finalVol * 10) / 10}</Text>
        </Flex>
        <Flex>
          <Text fontWeight='bold' width='175px'>{t`Specific Gravity`}</Text>
          <Text>{Math.round(calcBoiloff(boiloff).finalSg * 1000) / 1000}</Text>
        </Flex>

        <div className='row-reverse-wrapper'>
          <CloseModalButton onClick={() => props.closeDialogBoiloff()}>{t`Close`}</CloseModalButton>
        </div>
      </DialogContent>
    </DialogOverlay>
  )
}

export default BoiloffTool
